/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ProcessingFee {
    private final OptionalNullable<String> effectiveAt;
    private final OptionalNullable<String> type;
    private final Money amountMoney;

    @JsonCreator
    public ProcessingFee(@JsonProperty(value="effective_at") String effectiveAt, @JsonProperty(value="type") String type, @JsonProperty(value="amount_money") Money amountMoney) {
        this.effectiveAt = OptionalNullable.of((Object)effectiveAt);
        this.type = OptionalNullable.of((Object)type);
        this.amountMoney = amountMoney;
    }

    protected ProcessingFee(OptionalNullable<String> effectiveAt, OptionalNullable<String> type, Money amountMoney) {
        this.effectiveAt = effectiveAt;
        this.type = type;
        this.amountMoney = amountMoney;
    }

    @JsonGetter(value="effective_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEffectiveAt() {
        return this.effectiveAt;
    }

    @JsonIgnore
    public String getEffectiveAt() {
        return (String)OptionalNullable.getFrom(this.effectiveAt);
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetType() {
        return this.type;
    }

    @JsonIgnore
    public String getType() {
        return (String)OptionalNullable.getFrom(this.type);
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public int hashCode() {
        return Objects.hash(this.effectiveAt, this.type, this.amountMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProcessingFee)) {
            return false;
        }
        ProcessingFee other = (ProcessingFee)obj;
        return Objects.equals(this.effectiveAt, other.effectiveAt) && Objects.equals(this.type, other.type) && Objects.equals(this.amountMoney, other.amountMoney);
    }

    public String toString() {
        return "ProcessingFee [effectiveAt=" + this.effectiveAt + ", type=" + this.type + ", amountMoney=" + this.amountMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().amountMoney(this.getAmountMoney());
        builder.effectiveAt = this.internalGetEffectiveAt();
        builder.type = this.internalGetType();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> effectiveAt;
        private OptionalNullable<String> type;
        private Money amountMoney;

        public Builder effectiveAt(String effectiveAt) {
            this.effectiveAt = OptionalNullable.of((Object)effectiveAt);
            return this;
        }

        public Builder unsetEffectiveAt() {
            this.effectiveAt = null;
            return this;
        }

        public Builder type(String type) {
            this.type = OptionalNullable.of((Object)type);
            return this;
        }

        public Builder unsetType() {
            this.type = null;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public ProcessingFee build() {
            return new ProcessingFee(this.effectiveAt, this.type, this.amountMoney);
        }
    }
}

