/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class QrCodeOptions {
    private final String title;
    private final String body;
    private final String barcodeContents;

    @JsonCreator
    public QrCodeOptions(@JsonProperty(value="title") String title, @JsonProperty(value="body") String body, @JsonProperty(value="barcode_contents") String barcodeContents) {
        this.title = title;
        this.body = body;
        this.barcodeContents = barcodeContents;
    }

    @JsonGetter(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonGetter(value="body")
    public String getBody() {
        return this.body;
    }

    @JsonGetter(value="barcode_contents")
    public String getBarcodeContents() {
        return this.barcodeContents;
    }

    public int hashCode() {
        return Objects.hash(this.title, this.body, this.barcodeContents);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof QrCodeOptions)) {
            return false;
        }
        QrCodeOptions other = (QrCodeOptions)obj;
        return Objects.equals(this.title, other.title) && Objects.equals(this.body, other.body) && Objects.equals(this.barcodeContents, other.barcodeContents);
    }

    public String toString() {
        return "QrCodeOptions [title=" + this.title + ", body=" + this.body + ", barcodeContents=" + this.barcodeContents + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.title, this.body, this.barcodeContents);
        return builder;
    }

    public static class Builder {
        private String title;
        private String body;
        private String barcodeContents;

        public Builder(String title, String body, String barcodeContents) {
            this.title = title;
            this.body = body;
            this.barcodeContents = barcodeContents;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder barcodeContents(String barcodeContents) {
            this.barcodeContents = barcodeContents;
            return this;
        }

        public QrCodeOptions build() {
            return new QrCodeOptions(this.title, this.body, this.barcodeContents);
        }
    }
}

