/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.AdditionalRecipient;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class Refund {
    private final String id;
    private final String locationId;
    private final OptionalNullable<String> transactionId;
    private final String tenderId;
    private final String createdAt;
    private final String reason;
    private final Money amountMoney;
    private final String status;
    private final Money processingFeeMoney;
    private final OptionalNullable<List<AdditionalRecipient>> additionalRecipients;

    @JsonCreator
    public Refund(@JsonProperty(value="id") String id, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="tender_id") String tenderId, @JsonProperty(value="reason") String reason, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="status") String status, @JsonProperty(value="transaction_id") String transactionId, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="processing_fee_money") Money processingFeeMoney, @JsonProperty(value="additional_recipients") List<AdditionalRecipient> additionalRecipients) {
        this.id = id;
        this.locationId = locationId;
        this.transactionId = OptionalNullable.of((Object)transactionId);
        this.tenderId = tenderId;
        this.createdAt = createdAt;
        this.reason = reason;
        this.amountMoney = amountMoney;
        this.status = status;
        this.processingFeeMoney = processingFeeMoney;
        this.additionalRecipients = OptionalNullable.of(additionalRecipients);
    }

    protected Refund(String id, String locationId, String tenderId, String reason, Money amountMoney, String status, OptionalNullable<String> transactionId, String createdAt, Money processingFeeMoney, OptionalNullable<List<AdditionalRecipient>> additionalRecipients) {
        this.id = id;
        this.locationId = locationId;
        this.transactionId = transactionId;
        this.tenderId = tenderId;
        this.createdAt = createdAt;
        this.reason = reason;
        this.amountMoney = amountMoney;
        this.status = status;
        this.processingFeeMoney = processingFeeMoney;
        this.additionalRecipients = additionalRecipients;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="transaction_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTransactionId() {
        return this.transactionId;
    }

    @JsonIgnore
    public String getTransactionId() {
        return (String)OptionalNullable.getFrom(this.transactionId);
    }

    @JsonGetter(value="tender_id")
    public String getTenderId() {
        return this.tenderId;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="reason")
    public String getReason() {
        return this.reason;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="processing_fee_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getProcessingFeeMoney() {
        return this.processingFeeMoney;
    }

    @JsonGetter(value="additional_recipients")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<AdditionalRecipient>> internalGetAdditionalRecipients() {
        return this.additionalRecipients;
    }

    @JsonIgnore
    public List<AdditionalRecipient> getAdditionalRecipients() {
        return (List)OptionalNullable.getFrom(this.additionalRecipients);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.locationId, this.transactionId, this.tenderId, this.createdAt, this.reason, this.amountMoney, this.status, this.processingFeeMoney, this.additionalRecipients);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Refund)) {
            return false;
        }
        Refund other = (Refund)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.transactionId, other.transactionId) && Objects.equals(this.tenderId, other.tenderId) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.reason, other.reason) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.status, other.status) && Objects.equals(this.processingFeeMoney, other.processingFeeMoney) && Objects.equals(this.additionalRecipients, other.additionalRecipients);
    }

    public String toString() {
        return "Refund [id=" + this.id + ", locationId=" + this.locationId + ", tenderId=" + this.tenderId + ", reason=" + this.reason + ", amountMoney=" + this.amountMoney + ", status=" + this.status + ", transactionId=" + this.transactionId + ", createdAt=" + this.createdAt + ", processingFeeMoney=" + this.processingFeeMoney + ", additionalRecipients=" + this.additionalRecipients + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.id, this.locationId, this.tenderId, this.reason, this.amountMoney, this.status).createdAt(this.getCreatedAt()).processingFeeMoney(this.getProcessingFeeMoney());
        builder.transactionId = this.internalGetTransactionId();
        builder.additionalRecipients = this.internalGetAdditionalRecipients();
        return builder;
    }

    public static class Builder {
        private String id;
        private String locationId;
        private String tenderId;
        private String reason;
        private Money amountMoney;
        private String status;
        private OptionalNullable<String> transactionId;
        private String createdAt;
        private Money processingFeeMoney;
        private OptionalNullable<List<AdditionalRecipient>> additionalRecipients;

        public Builder(String id, String locationId, String tenderId, String reason, Money amountMoney, String status) {
            this.id = id;
            this.locationId = locationId;
            this.tenderId = tenderId;
            this.reason = reason;
            this.amountMoney = amountMoney;
            this.status = status;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder tenderId(String tenderId) {
            this.tenderId = tenderId;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder transactionId(String transactionId) {
            this.transactionId = OptionalNullable.of((Object)transactionId);
            return this;
        }

        public Builder unsetTransactionId() {
            this.transactionId = null;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder processingFeeMoney(Money processingFeeMoney) {
            this.processingFeeMoney = processingFeeMoney;
            return this;
        }

        public Builder additionalRecipients(List<AdditionalRecipient> additionalRecipients) {
            this.additionalRecipients = OptionalNullable.of(additionalRecipients);
            return this;
        }

        public Builder unsetAdditionalRecipients() {
            this.additionalRecipients = null;
            return this;
        }

        public Refund build() {
            return new Refund(this.id, this.locationId, this.tenderId, this.reason, this.amountMoney, this.status, this.transactionId, this.createdAt, this.processingFeeMoney, this.additionalRecipients);
        }
    }
}

