/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class RenewTokenResponse {
    private HttpContext httpContext;
    private final String accessToken;
    private final String tokenType;
    private final String expiresAt;
    private final String merchantId;
    private final String subscriptionId;
    private final String planId;
    private final List<Error> errors;

    @JsonCreator
    public RenewTokenResponse(@JsonProperty(value="access_token") String accessToken, @JsonProperty(value="token_type") String tokenType, @JsonProperty(value="expires_at") String expiresAt, @JsonProperty(value="merchant_id") String merchantId, @JsonProperty(value="subscription_id") String subscriptionId, @JsonProperty(value="plan_id") String planId, @JsonProperty(value="errors") List<Error> errors) {
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.expiresAt = expiresAt;
        this.merchantId = merchantId;
        this.subscriptionId = subscriptionId;
        this.planId = planId;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="access_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAccessToken() {
        return this.accessToken;
    }

    @JsonGetter(value="token_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTokenType() {
        return this.tokenType;
    }

    @JsonGetter(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getExpiresAt() {
        return this.expiresAt;
    }

    @JsonGetter(value="merchant_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMerchantId() {
        return this.merchantId;
    }

    @JsonGetter(value="subscription_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @JsonGetter(value="plan_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPlanId() {
        return this.planId;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.tokenType, this.expiresAt, this.merchantId, this.subscriptionId, this.planId, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RenewTokenResponse)) {
            return false;
        }
        RenewTokenResponse other = (RenewTokenResponse)obj;
        return Objects.equals(this.accessToken, other.accessToken) && Objects.equals(this.tokenType, other.tokenType) && Objects.equals(this.expiresAt, other.expiresAt) && Objects.equals(this.merchantId, other.merchantId) && Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals(this.planId, other.planId) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "RenewTokenResponse [accessToken=" + this.accessToken + ", tokenType=" + this.tokenType + ", expiresAt=" + this.expiresAt + ", merchantId=" + this.merchantId + ", subscriptionId=" + this.subscriptionId + ", planId=" + this.planId + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().accessToken(this.getAccessToken()).tokenType(this.getTokenType()).expiresAt(this.getExpiresAt()).merchantId(this.getMerchantId()).subscriptionId(this.getSubscriptionId()).planId(this.getPlanId()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private String accessToken;
        private String tokenType;
        private String expiresAt;
        private String merchantId;
        private String subscriptionId;
        private String planId;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public Builder expiresAt(String expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public Builder planId(String planId) {
            this.planId = planId;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public RenewTokenResponse build() {
            RenewTokenResponse model = new RenewTokenResponse(this.accessToken, this.tokenType, this.expiresAt, this.merchantId, this.subscriptionId, this.planId, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

