/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class RetrieveCatalogObjectRequest {
    private final OptionalNullable<Boolean> includeRelatedObjects;
    private final OptionalNullable<Long> catalogVersion;
    private final OptionalNullable<Boolean> includeCategoryPathToRoot;

    @JsonCreator
    public RetrieveCatalogObjectRequest(@JsonProperty(value="include_related_objects") Boolean includeRelatedObjects, @JsonProperty(value="catalog_version") Long catalogVersion, @JsonProperty(value="include_category_path_to_root") Boolean includeCategoryPathToRoot) {
        this.includeRelatedObjects = OptionalNullable.of((Object)includeRelatedObjects);
        this.catalogVersion = OptionalNullable.of((Object)catalogVersion);
        this.includeCategoryPathToRoot = OptionalNullable.of((Object)includeCategoryPathToRoot);
    }

    protected RetrieveCatalogObjectRequest(OptionalNullable<Boolean> includeRelatedObjects, OptionalNullable<Long> catalogVersion, OptionalNullable<Boolean> includeCategoryPathToRoot) {
        this.includeRelatedObjects = includeRelatedObjects;
        this.catalogVersion = catalogVersion;
        this.includeCategoryPathToRoot = includeCategoryPathToRoot;
    }

    @JsonGetter(value="include_related_objects")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetIncludeRelatedObjects() {
        return this.includeRelatedObjects;
    }

    @JsonIgnore
    public Boolean getIncludeRelatedObjects() {
        return (Boolean)OptionalNullable.getFrom(this.includeRelatedObjects);
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonIgnore
    public Long getCatalogVersion() {
        return (Long)OptionalNullable.getFrom(this.catalogVersion);
    }

    @JsonGetter(value="include_category_path_to_root")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetIncludeCategoryPathToRoot() {
        return this.includeCategoryPathToRoot;
    }

    @JsonIgnore
    public Boolean getIncludeCategoryPathToRoot() {
        return (Boolean)OptionalNullable.getFrom(this.includeCategoryPathToRoot);
    }

    public int hashCode() {
        return Objects.hash(this.includeRelatedObjects, this.catalogVersion, this.includeCategoryPathToRoot);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveCatalogObjectRequest)) {
            return false;
        }
        RetrieveCatalogObjectRequest other = (RetrieveCatalogObjectRequest)obj;
        return Objects.equals(this.includeRelatedObjects, other.includeRelatedObjects) && Objects.equals(this.catalogVersion, other.catalogVersion) && Objects.equals(this.includeCategoryPathToRoot, other.includeCategoryPathToRoot);
    }

    public String toString() {
        return "RetrieveCatalogObjectRequest [includeRelatedObjects=" + this.includeRelatedObjects + ", catalogVersion=" + this.catalogVersion + ", includeCategoryPathToRoot=" + this.includeCategoryPathToRoot + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.includeRelatedObjects = this.internalGetIncludeRelatedObjects();
        builder.catalogVersion = this.internalGetCatalogVersion();
        builder.includeCategoryPathToRoot = this.internalGetIncludeCategoryPathToRoot();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<Boolean> includeRelatedObjects;
        private OptionalNullable<Long> catalogVersion;
        private OptionalNullable<Boolean> includeCategoryPathToRoot;

        public Builder includeRelatedObjects(Boolean includeRelatedObjects) {
            this.includeRelatedObjects = OptionalNullable.of((Object)includeRelatedObjects);
            return this;
        }

        public Builder unsetIncludeRelatedObjects() {
            this.includeRelatedObjects = null;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = OptionalNullable.of((Object)catalogVersion);
            return this;
        }

        public Builder unsetCatalogVersion() {
            this.catalogVersion = null;
            return this;
        }

        public Builder includeCategoryPathToRoot(Boolean includeCategoryPathToRoot) {
            this.includeCategoryPathToRoot = OptionalNullable.of((Object)includeCategoryPathToRoot);
            return this;
        }

        public Builder unsetIncludeCategoryPathToRoot() {
            this.includeCategoryPathToRoot = null;
            return this;
        }

        public RetrieveCatalogObjectRequest build() {
            return new RetrieveCatalogObjectRequest(this.includeRelatedObjects, this.catalogVersion, this.includeCategoryPathToRoot);
        }
    }
}

