/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CatalogObject;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class RetrieveCatalogObjectResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final CatalogObject object;
    private final List<CatalogObject> relatedObjects;

    @JsonCreator
    public RetrieveCatalogObjectResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="object") CatalogObject object, @JsonProperty(value="related_objects") List<CatalogObject> relatedObjects) {
        this.errors = errors;
        this.object = object;
        this.relatedObjects = relatedObjects;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="object")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogObject getObject() {
        return this.object;
    }

    @JsonGetter(value="related_objects")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CatalogObject> getRelatedObjects() {
        return this.relatedObjects;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.object, this.relatedObjects);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveCatalogObjectResponse)) {
            return false;
        }
        RetrieveCatalogObjectResponse other = (RetrieveCatalogObjectResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.object, other.object) && Objects.equals(this.relatedObjects, other.relatedObjects);
    }

    public String toString() {
        return "RetrieveCatalogObjectResponse [errors=" + this.errors + ", object=" + this.object + ", relatedObjects=" + this.relatedObjects + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).object(this.getObject()).relatedObjects(this.getRelatedObjects());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private CatalogObject object;
        private List<CatalogObject> relatedObjects;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder object(CatalogObject object) {
            this.object = object;
            return this;
        }

        public Builder relatedObjects(List<CatalogObject> relatedObjects) {
            this.relatedObjects = relatedObjects;
            return this;
        }

        public RetrieveCatalogObjectResponse build() {
            RetrieveCatalogObjectResponse model = new RetrieveCatalogObjectResponse(this.errors, this.object, this.relatedObjects);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

