/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Employee;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class RetrieveEmployeeResponse {
    private HttpContext httpContext;
    private final Employee employee;
    private final List<Error> errors;

    @JsonCreator
    public RetrieveEmployeeResponse(@JsonProperty(value="employee") Employee employee, @JsonProperty(value="errors") List<Error> errors) {
        this.employee = employee;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="employee")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Employee getEmployee() {
        return this.employee;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.employee, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveEmployeeResponse)) {
            return false;
        }
        RetrieveEmployeeResponse other = (RetrieveEmployeeResponse)obj;
        return Objects.equals(this.employee, other.employee) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "RetrieveEmployeeResponse [employee=" + this.employee + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().employee(this.getEmployee()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private Employee employee;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder employee(Employee employee) {
            this.employee = employee;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public RetrieveEmployeeResponse build() {
            RetrieveEmployeeResponse model = new RetrieveEmployeeResponse(this.employee, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

