/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.InventoryAdjustment;
import java.util.List;
import java.util.Objects;

public class RetrieveInventoryAdjustmentResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final InventoryAdjustment adjustment;

    @JsonCreator
    public RetrieveInventoryAdjustmentResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="adjustment") InventoryAdjustment adjustment) {
        this.errors = errors;
        this.adjustment = adjustment;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="adjustment")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public InventoryAdjustment getAdjustment() {
        return this.adjustment;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.adjustment);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveInventoryAdjustmentResponse)) {
            return false;
        }
        RetrieveInventoryAdjustmentResponse other = (RetrieveInventoryAdjustmentResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.adjustment, other.adjustment);
    }

    public String toString() {
        return "RetrieveInventoryAdjustmentResponse [errors=" + this.errors + ", adjustment=" + this.adjustment + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).adjustment(this.getAdjustment());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private InventoryAdjustment adjustment;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder adjustment(InventoryAdjustment adjustment) {
            this.adjustment = adjustment;
            return this;
        }

        public RetrieveInventoryAdjustmentResponse build() {
            RetrieveInventoryAdjustmentResponse model = new RetrieveInventoryAdjustmentResponse(this.errors, this.adjustment);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

