/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class RetrieveInventoryChangesRequest {
    private final OptionalNullable<String> locationIds;
    private final OptionalNullable<String> cursor;

    @JsonCreator
    public RetrieveInventoryChangesRequest(@JsonProperty(value="location_ids") String locationIds, @JsonProperty(value="cursor") String cursor) {
        this.locationIds = OptionalNullable.of((Object)locationIds);
        this.cursor = OptionalNullable.of((Object)cursor);
    }

    protected RetrieveInventoryChangesRequest(OptionalNullable<String> locationIds, OptionalNullable<String> cursor) {
        this.locationIds = locationIds;
        this.cursor = cursor;
    }

    @JsonGetter(value="location_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationIds() {
        return this.locationIds;
    }

    @JsonIgnore
    public String getLocationIds() {
        return (String)OptionalNullable.getFrom(this.locationIds);
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.locationIds, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveInventoryChangesRequest)) {
            return false;
        }
        RetrieveInventoryChangesRequest other = (RetrieveInventoryChangesRequest)obj;
        return Objects.equals(this.locationIds, other.locationIds) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "RetrieveInventoryChangesRequest [locationIds=" + this.locationIds + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.locationIds = this.internalGetLocationIds();
        builder.cursor = this.internalGetCursor();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> locationIds;
        private OptionalNullable<String> cursor;

        public Builder locationIds(String locationIds) {
            this.locationIds = OptionalNullable.of((Object)locationIds);
            return this;
        }

        public Builder unsetLocationIds() {
            this.locationIds = null;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public RetrieveInventoryChangesRequest build() {
            return new RetrieveInventoryChangesRequest(this.locationIds, this.cursor);
        }
    }
}

