/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.LocationBookingProfile;
import java.util.List;
import java.util.Objects;

public class RetrieveLocationBookingProfileResponse {
    private HttpContext httpContext;
    private final LocationBookingProfile locationBookingProfile;
    private final List<Error> errors;

    @JsonCreator
    public RetrieveLocationBookingProfileResponse(@JsonProperty(value="location_booking_profile") LocationBookingProfile locationBookingProfile, @JsonProperty(value="errors") List<Error> errors) {
        this.locationBookingProfile = locationBookingProfile;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="location_booking_profile")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LocationBookingProfile getLocationBookingProfile() {
        return this.locationBookingProfile;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.locationBookingProfile, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveLocationBookingProfileResponse)) {
            return false;
        }
        RetrieveLocationBookingProfileResponse other = (RetrieveLocationBookingProfileResponse)obj;
        return Objects.equals(this.locationBookingProfile, other.locationBookingProfile) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "RetrieveLocationBookingProfileResponse [locationBookingProfile=" + this.locationBookingProfile + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().locationBookingProfile(this.getLocationBookingProfile()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private LocationBookingProfile locationBookingProfile;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder locationBookingProfile(LocationBookingProfile locationBookingProfile) {
            this.locationBookingProfile = locationBookingProfile;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public RetrieveLocationBookingProfileResponse build() {
            RetrieveLocationBookingProfileResponse model = new RetrieveLocationBookingProfileResponse(this.locationBookingProfile, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

