/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.LoyaltyProgram;
import java.util.List;
import java.util.Objects;

public class RetrieveLoyaltyProgramResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final LoyaltyProgram program;

    @JsonCreator
    public RetrieveLoyaltyProgramResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="program") LoyaltyProgram program) {
        this.errors = errors;
        this.program = program;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="program")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyProgram getProgram() {
        return this.program;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.program);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveLoyaltyProgramResponse)) {
            return false;
        }
        RetrieveLoyaltyProgramResponse other = (RetrieveLoyaltyProgramResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.program, other.program);
    }

    public String toString() {
        return "RetrieveLoyaltyProgramResponse [errors=" + this.errors + ", program=" + this.program + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).program(this.getProgram());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private LoyaltyProgram program;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder program(LoyaltyProgram program) {
            this.program = program;
            return this;
        }

        public RetrieveLoyaltyProgramResponse build() {
            RetrieveLoyaltyProgramResponse model = new RetrieveLoyaltyProgramResponse(this.errors, this.program);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

