/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CheckoutMerchantSettings;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class RetrieveMerchantSettingsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final CheckoutMerchantSettings merchantSettings;

    @JsonCreator
    public RetrieveMerchantSettingsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="merchant_settings") CheckoutMerchantSettings merchantSettings) {
        this.errors = errors;
        this.merchantSettings = merchantSettings;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="merchant_settings")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CheckoutMerchantSettings getMerchantSettings() {
        return this.merchantSettings;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.merchantSettings);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveMerchantSettingsResponse)) {
            return false;
        }
        RetrieveMerchantSettingsResponse other = (RetrieveMerchantSettingsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.merchantSettings, other.merchantSettings);
    }

    public String toString() {
        return "RetrieveMerchantSettingsResponse [errors=" + this.errors + ", merchantSettings=" + this.merchantSettings + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).merchantSettings(this.getMerchantSettings());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private CheckoutMerchantSettings merchantSettings;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder merchantSettings(CheckoutMerchantSettings merchantSettings) {
            this.merchantSettings = merchantSettings;
            return this;
        }

        public RetrieveMerchantSettingsResponse build() {
            RetrieveMerchantSettingsResponse model = new RetrieveMerchantSettingsResponse(this.errors, this.merchantSettings);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

