/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class RetrieveOrderCustomAttributeRequest {
    private final Integer version;
    private final OptionalNullable<Boolean> withDefinition;

    @JsonCreator
    public RetrieveOrderCustomAttributeRequest(@JsonProperty(value="version") Integer version, @JsonProperty(value="with_definition") Boolean withDefinition) {
        this.version = version;
        this.withDefinition = OptionalNullable.of((Object)withDefinition);
    }

    protected RetrieveOrderCustomAttributeRequest(Integer version, OptionalNullable<Boolean> withDefinition) {
        this.version = version;
        this.withDefinition = withDefinition;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="with_definition")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetWithDefinition() {
        return this.withDefinition;
    }

    @JsonIgnore
    public Boolean getWithDefinition() {
        return (Boolean)OptionalNullable.getFrom(this.withDefinition);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.withDefinition);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveOrderCustomAttributeRequest)) {
            return false;
        }
        RetrieveOrderCustomAttributeRequest other = (RetrieveOrderCustomAttributeRequest)obj;
        return Objects.equals(this.version, other.version) && Objects.equals(this.withDefinition, other.withDefinition);
    }

    public String toString() {
        return "RetrieveOrderCustomAttributeRequest [version=" + this.version + ", withDefinition=" + this.withDefinition + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().version(this.getVersion());
        builder.withDefinition = this.internalGetWithDefinition();
        return builder;
    }

    public static class Builder {
        private Integer version;
        private OptionalNullable<Boolean> withDefinition;

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder withDefinition(Boolean withDefinition) {
            this.withDefinition = OptionalNullable.of((Object)withDefinition);
            return this;
        }

        public Builder unsetWithDefinition() {
            this.withDefinition = null;
            return this;
        }

        public RetrieveOrderCustomAttributeRequest build() {
            return new RetrieveOrderCustomAttributeRequest(this.version, this.withDefinition);
        }
    }
}

