/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.TeamMemberBookingProfile;
import java.util.List;
import java.util.Objects;

public class RetrieveTeamMemberBookingProfileResponse {
    private HttpContext httpContext;
    private final TeamMemberBookingProfile teamMemberBookingProfile;
    private final List<Error> errors;

    @JsonCreator
    public RetrieveTeamMemberBookingProfileResponse(@JsonProperty(value="team_member_booking_profile") TeamMemberBookingProfile teamMemberBookingProfile, @JsonProperty(value="errors") List<Error> errors) {
        this.teamMemberBookingProfile = teamMemberBookingProfile;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="team_member_booking_profile")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TeamMemberBookingProfile getTeamMemberBookingProfile() {
        return this.teamMemberBookingProfile;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.teamMemberBookingProfile, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveTeamMemberBookingProfileResponse)) {
            return false;
        }
        RetrieveTeamMemberBookingProfileResponse other = (RetrieveTeamMemberBookingProfileResponse)obj;
        return Objects.equals(this.teamMemberBookingProfile, other.teamMemberBookingProfile) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "RetrieveTeamMemberBookingProfileResponse [teamMemberBookingProfile=" + this.teamMemberBookingProfile + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().teamMemberBookingProfile(this.getTeamMemberBookingProfile()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private TeamMemberBookingProfile teamMemberBookingProfile;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder teamMemberBookingProfile(TeamMemberBookingProfile teamMemberBookingProfile) {
            this.teamMemberBookingProfile = teamMemberBookingProfile;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public RetrieveTeamMemberBookingProfileResponse build() {
            RetrieveTeamMemberBookingProfileResponse model = new RetrieveTeamMemberBookingProfileResponse(this.teamMemberBookingProfile, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

