/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.WageSetting;
import java.util.List;
import java.util.Objects;

public class RetrieveWageSettingResponse {
    private HttpContext httpContext;
    private final WageSetting wageSetting;
    private final List<Error> errors;

    @JsonCreator
    public RetrieveWageSettingResponse(@JsonProperty(value="wage_setting") WageSetting wageSetting, @JsonProperty(value="errors") List<Error> errors) {
        this.wageSetting = wageSetting;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="wage_setting")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public WageSetting getWageSetting() {
        return this.wageSetting;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.wageSetting, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveWageSettingResponse)) {
            return false;
        }
        RetrieveWageSettingResponse other = (RetrieveWageSettingResponse)obj;
        return Objects.equals(this.wageSetting, other.wageSetting) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "RetrieveWageSettingResponse [wageSetting=" + this.wageSetting + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().wageSetting(this.getWageSetting()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private WageSetting wageSetting;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder wageSetting(WageSetting wageSetting) {
            this.wageSetting = wageSetting;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public RetrieveWageSettingResponse build() {
            RetrieveWageSettingResponse model = new RetrieveWageSettingResponse(this.wageSetting, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

