/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CustomAttributeFilter;
import java.util.List;
import java.util.Objects;

public class SearchCatalogItemsRequest {
    private final String textFilter;
    private final List<String> categoryIds;
    private final List<String> stockLevels;
    private final List<String> enabledLocationIds;
    private final String cursor;
    private final Integer limit;
    private final String sortOrder;
    private final List<String> productTypes;
    private final List<CustomAttributeFilter> customAttributeFilters;
    private final String archivedState;

    @JsonCreator
    public SearchCatalogItemsRequest(@JsonProperty(value="text_filter") String textFilter, @JsonProperty(value="category_ids") List<String> categoryIds, @JsonProperty(value="stock_levels") List<String> stockLevels, @JsonProperty(value="enabled_location_ids") List<String> enabledLocationIds, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="sort_order") String sortOrder, @JsonProperty(value="product_types") List<String> productTypes, @JsonProperty(value="custom_attribute_filters") List<CustomAttributeFilter> customAttributeFilters, @JsonProperty(value="archived_state") String archivedState) {
        this.textFilter = textFilter;
        this.categoryIds = categoryIds;
        this.stockLevels = stockLevels;
        this.enabledLocationIds = enabledLocationIds;
        this.cursor = cursor;
        this.limit = limit;
        this.sortOrder = sortOrder;
        this.productTypes = productTypes;
        this.customAttributeFilters = customAttributeFilters;
        this.archivedState = archivedState;
    }

    @JsonGetter(value="text_filter")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTextFilter() {
        return this.textFilter;
    }

    @JsonGetter(value="category_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getCategoryIds() {
        return this.categoryIds;
    }

    @JsonGetter(value="stock_levels")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getStockLevels() {
        return this.stockLevels;
    }

    @JsonGetter(value="enabled_location_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getEnabledLocationIds() {
        return this.enabledLocationIds;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getLimit() {
        return this.limit;
    }

    @JsonGetter(value="sort_order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSortOrder() {
        return this.sortOrder;
    }

    @JsonGetter(value="product_types")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getProductTypes() {
        return this.productTypes;
    }

    @JsonGetter(value="custom_attribute_filters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CustomAttributeFilter> getCustomAttributeFilters() {
        return this.customAttributeFilters;
    }

    @JsonGetter(value="archived_state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getArchivedState() {
        return this.archivedState;
    }

    public int hashCode() {
        return Objects.hash(this.textFilter, this.categoryIds, this.stockLevels, this.enabledLocationIds, this.cursor, this.limit, this.sortOrder, this.productTypes, this.customAttributeFilters, this.archivedState);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchCatalogItemsRequest)) {
            return false;
        }
        SearchCatalogItemsRequest other = (SearchCatalogItemsRequest)obj;
        return Objects.equals(this.textFilter, other.textFilter) && Objects.equals(this.categoryIds, other.categoryIds) && Objects.equals(this.stockLevels, other.stockLevels) && Objects.equals(this.enabledLocationIds, other.enabledLocationIds) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.limit, other.limit) && Objects.equals(this.sortOrder, other.sortOrder) && Objects.equals(this.productTypes, other.productTypes) && Objects.equals(this.customAttributeFilters, other.customAttributeFilters) && Objects.equals(this.archivedState, other.archivedState);
    }

    public String toString() {
        return "SearchCatalogItemsRequest [textFilter=" + this.textFilter + ", categoryIds=" + this.categoryIds + ", stockLevels=" + this.stockLevels + ", enabledLocationIds=" + this.enabledLocationIds + ", cursor=" + this.cursor + ", limit=" + this.limit + ", sortOrder=" + this.sortOrder + ", productTypes=" + this.productTypes + ", customAttributeFilters=" + this.customAttributeFilters + ", archivedState=" + this.archivedState + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().textFilter(this.getTextFilter()).categoryIds(this.getCategoryIds()).stockLevels(this.getStockLevels()).enabledLocationIds(this.getEnabledLocationIds()).cursor(this.getCursor()).limit(this.getLimit()).sortOrder(this.getSortOrder()).productTypes(this.getProductTypes()).customAttributeFilters(this.getCustomAttributeFilters()).archivedState(this.getArchivedState());
        return builder;
    }

    public static class Builder {
        private String textFilter;
        private List<String> categoryIds;
        private List<String> stockLevels;
        private List<String> enabledLocationIds;
        private String cursor;
        private Integer limit;
        private String sortOrder;
        private List<String> productTypes;
        private List<CustomAttributeFilter> customAttributeFilters;
        private String archivedState;

        public Builder textFilter(String textFilter) {
            this.textFilter = textFilter;
            return this;
        }

        public Builder categoryIds(List<String> categoryIds) {
            this.categoryIds = categoryIds;
            return this;
        }

        public Builder stockLevels(List<String> stockLevels) {
            this.stockLevels = stockLevels;
            return this;
        }

        public Builder enabledLocationIds(List<String> enabledLocationIds) {
            this.enabledLocationIds = enabledLocationIds;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder productTypes(List<String> productTypes) {
            this.productTypes = productTypes;
            return this;
        }

        public Builder customAttributeFilters(List<CustomAttributeFilter> customAttributeFilters) {
            this.customAttributeFilters = customAttributeFilters;
            return this;
        }

        public Builder archivedState(String archivedState) {
            this.archivedState = archivedState;
            return this;
        }

        public SearchCatalogItemsRequest build() {
            return new SearchCatalogItemsRequest(this.textFilter, this.categoryIds, this.stockLevels, this.enabledLocationIds, this.cursor, this.limit, this.sortOrder, this.productTypes, this.customAttributeFilters, this.archivedState);
        }
    }
}

