/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CatalogQuery;
import java.util.List;
import java.util.Objects;

public class SearchCatalogObjectsRequest {
    private final String cursor;
    private final List<String> objectTypes;
    private final Boolean includeDeletedObjects;
    private final Boolean includeRelatedObjects;
    private final String beginTime;
    private final CatalogQuery query;
    private final Integer limit;
    private final Boolean includeCategoryPathToRoot;

    @JsonCreator
    public SearchCatalogObjectsRequest(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="object_types") List<String> objectTypes, @JsonProperty(value="include_deleted_objects") Boolean includeDeletedObjects, @JsonProperty(value="include_related_objects") Boolean includeRelatedObjects, @JsonProperty(value="begin_time") String beginTime, @JsonProperty(value="query") CatalogQuery query, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="include_category_path_to_root") Boolean includeCategoryPathToRoot) {
        this.cursor = cursor;
        this.objectTypes = objectTypes;
        this.includeDeletedObjects = includeDeletedObjects;
        this.includeRelatedObjects = includeRelatedObjects;
        this.beginTime = beginTime;
        this.query = query;
        this.limit = limit;
        this.includeCategoryPathToRoot = includeCategoryPathToRoot;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="object_types")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getObjectTypes() {
        return this.objectTypes;
    }

    @JsonGetter(value="include_deleted_objects")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIncludeDeletedObjects() {
        return this.includeDeletedObjects;
    }

    @JsonGetter(value="include_related_objects")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIncludeRelatedObjects() {
        return this.includeRelatedObjects;
    }

    @JsonGetter(value="begin_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBeginTime() {
        return this.beginTime;
    }

    @JsonGetter(value="query")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogQuery getQuery() {
        return this.query;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getLimit() {
        return this.limit;
    }

    @JsonGetter(value="include_category_path_to_root")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIncludeCategoryPathToRoot() {
        return this.includeCategoryPathToRoot;
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.objectTypes, this.includeDeletedObjects, this.includeRelatedObjects, this.beginTime, this.query, this.limit, this.includeCategoryPathToRoot);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchCatalogObjectsRequest)) {
            return false;
        }
        SearchCatalogObjectsRequest other = (SearchCatalogObjectsRequest)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.objectTypes, other.objectTypes) && Objects.equals(this.includeDeletedObjects, other.includeDeletedObjects) && Objects.equals(this.includeRelatedObjects, other.includeRelatedObjects) && Objects.equals(this.beginTime, other.beginTime) && Objects.equals(this.query, other.query) && Objects.equals(this.limit, other.limit) && Objects.equals(this.includeCategoryPathToRoot, other.includeCategoryPathToRoot);
    }

    public String toString() {
        return "SearchCatalogObjectsRequest [cursor=" + this.cursor + ", objectTypes=" + this.objectTypes + ", includeDeletedObjects=" + this.includeDeletedObjects + ", includeRelatedObjects=" + this.includeRelatedObjects + ", beginTime=" + this.beginTime + ", query=" + this.query + ", limit=" + this.limit + ", includeCategoryPathToRoot=" + this.includeCategoryPathToRoot + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().cursor(this.getCursor()).objectTypes(this.getObjectTypes()).includeDeletedObjects(this.getIncludeDeletedObjects()).includeRelatedObjects(this.getIncludeRelatedObjects()).beginTime(this.getBeginTime()).query(this.getQuery()).limit(this.getLimit()).includeCategoryPathToRoot(this.getIncludeCategoryPathToRoot());
        return builder;
    }

    public static class Builder {
        private String cursor;
        private List<String> objectTypes;
        private Boolean includeDeletedObjects;
        private Boolean includeRelatedObjects;
        private String beginTime;
        private CatalogQuery query;
        private Integer limit;
        private Boolean includeCategoryPathToRoot;

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder objectTypes(List<String> objectTypes) {
            this.objectTypes = objectTypes;
            return this;
        }

        public Builder includeDeletedObjects(Boolean includeDeletedObjects) {
            this.includeDeletedObjects = includeDeletedObjects;
            return this;
        }

        public Builder includeRelatedObjects(Boolean includeRelatedObjects) {
            this.includeRelatedObjects = includeRelatedObjects;
            return this;
        }

        public Builder beginTime(String beginTime) {
            this.beginTime = beginTime;
            return this;
        }

        public Builder query(CatalogQuery query) {
            this.query = query;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder includeCategoryPathToRoot(Boolean includeCategoryPathToRoot) {
            this.includeCategoryPathToRoot = includeCategoryPathToRoot;
            return this;
        }

        public SearchCatalogObjectsRequest build() {
            return new SearchCatalogObjectsRequest(this.cursor, this.objectTypes, this.includeDeletedObjects, this.includeRelatedObjects, this.beginTime, this.query, this.limit, this.includeCategoryPathToRoot);
        }
    }
}

