/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.InvoiceQuery;
import java.util.Objects;

public class SearchInvoicesRequest {
    private final InvoiceQuery query;
    private final Integer limit;
    private final String cursor;

    @JsonCreator
    public SearchInvoicesRequest(@JsonProperty(value="query") InvoiceQuery query, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="cursor") String cursor) {
        this.query = query;
        this.limit = limit;
        this.cursor = cursor;
    }

    @JsonGetter(value="query")
    public InvoiceQuery getQuery() {
        return this.query;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getLimit() {
        return this.limit;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.query, this.limit, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchInvoicesRequest)) {
            return false;
        }
        SearchInvoicesRequest other = (SearchInvoicesRequest)obj;
        return Objects.equals(this.query, other.query) && Objects.equals(this.limit, other.limit) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "SearchInvoicesRequest [query=" + this.query + ", limit=" + this.limit + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.query).limit(this.getLimit()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private InvoiceQuery query;
        private Integer limit;
        private String cursor;

        public Builder(InvoiceQuery query) {
            this.query = query;
        }

        public Builder query(InvoiceQuery query) {
            this.query = query;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public SearchInvoicesRequest build() {
            return new SearchInvoicesRequest(this.query, this.limit, this.cursor);
        }
    }
}

