/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.TimeRange;
import java.util.Objects;

public class SearchOrdersDateTimeFilter {
    private final TimeRange createdAt;
    private final TimeRange updatedAt;
    private final TimeRange closedAt;

    @JsonCreator
    public SearchOrdersDateTimeFilter(@JsonProperty(value="created_at") TimeRange createdAt, @JsonProperty(value="updated_at") TimeRange updatedAt, @JsonProperty(value="closed_at") TimeRange closedAt) {
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.closedAt = closedAt;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TimeRange getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TimeRange getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="closed_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TimeRange getClosedAt() {
        return this.closedAt;
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.updatedAt, this.closedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchOrdersDateTimeFilter)) {
            return false;
        }
        SearchOrdersDateTimeFilter other = (SearchOrdersDateTimeFilter)obj;
        return Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.closedAt, other.closedAt);
    }

    public String toString() {
        return "SearchOrdersDateTimeFilter [createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", closedAt=" + this.closedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).closedAt(this.getClosedAt());
        return builder;
    }

    public static class Builder {
        private TimeRange createdAt;
        private TimeRange updatedAt;
        private TimeRange closedAt;

        public Builder createdAt(TimeRange createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(TimeRange updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder closedAt(TimeRange closedAt) {
            this.closedAt = closedAt;
            return this;
        }

        public SearchOrdersDateTimeFilter build() {
            return new SearchOrdersDateTimeFilter(this.createdAt, this.updatedAt, this.closedAt);
        }
    }
}

