/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class SearchOrdersFulfillmentFilter {
    private final OptionalNullable<List<String>> fulfillmentTypes;
    private final OptionalNullable<List<String>> fulfillmentStates;

    @JsonCreator
    public SearchOrdersFulfillmentFilter(@JsonProperty(value="fulfillment_types") List<String> fulfillmentTypes, @JsonProperty(value="fulfillment_states") List<String> fulfillmentStates) {
        this.fulfillmentTypes = OptionalNullable.of(fulfillmentTypes);
        this.fulfillmentStates = OptionalNullable.of(fulfillmentStates);
    }

    protected SearchOrdersFulfillmentFilter(OptionalNullable<List<String>> fulfillmentTypes, OptionalNullable<List<String>> fulfillmentStates) {
        this.fulfillmentTypes = fulfillmentTypes;
        this.fulfillmentStates = fulfillmentStates;
    }

    @JsonGetter(value="fulfillment_types")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetFulfillmentTypes() {
        return this.fulfillmentTypes;
    }

    @JsonIgnore
    public List<String> getFulfillmentTypes() {
        return (List)OptionalNullable.getFrom(this.fulfillmentTypes);
    }

    @JsonGetter(value="fulfillment_states")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetFulfillmentStates() {
        return this.fulfillmentStates;
    }

    @JsonIgnore
    public List<String> getFulfillmentStates() {
        return (List)OptionalNullable.getFrom(this.fulfillmentStates);
    }

    public int hashCode() {
        return Objects.hash(this.fulfillmentTypes, this.fulfillmentStates);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchOrdersFulfillmentFilter)) {
            return false;
        }
        SearchOrdersFulfillmentFilter other = (SearchOrdersFulfillmentFilter)obj;
        return Objects.equals(this.fulfillmentTypes, other.fulfillmentTypes) && Objects.equals(this.fulfillmentStates, other.fulfillmentStates);
    }

    public String toString() {
        return "SearchOrdersFulfillmentFilter [fulfillmentTypes=" + this.fulfillmentTypes + ", fulfillmentStates=" + this.fulfillmentStates + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.fulfillmentTypes = this.internalGetFulfillmentTypes();
        builder.fulfillmentStates = this.internalGetFulfillmentStates();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<List<String>> fulfillmentTypes;
        private OptionalNullable<List<String>> fulfillmentStates;

        public Builder fulfillmentTypes(List<String> fulfillmentTypes) {
            this.fulfillmentTypes = OptionalNullable.of(fulfillmentTypes);
            return this;
        }

        public Builder unsetFulfillmentTypes() {
            this.fulfillmentTypes = null;
            return this;
        }

        public Builder fulfillmentStates(List<String> fulfillmentStates) {
            this.fulfillmentStates = OptionalNullable.of(fulfillmentStates);
            return this;
        }

        public Builder unsetFulfillmentStates() {
            this.fulfillmentStates = null;
            return this;
        }

        public SearchOrdersFulfillmentFilter build() {
            return new SearchOrdersFulfillmentFilter(this.fulfillmentTypes, this.fulfillmentStates);
        }
    }
}

