/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.SearchOrdersFilter;
import com.squareup.square.models.SearchOrdersSort;
import java.util.Objects;

public class SearchOrdersQuery {
    private final SearchOrdersFilter filter;
    private final SearchOrdersSort sort;

    @JsonCreator
    public SearchOrdersQuery(@JsonProperty(value="filter") SearchOrdersFilter filter, @JsonProperty(value="sort") SearchOrdersSort sort) {
        this.filter = filter;
        this.sort = sort;
    }

    @JsonGetter(value="filter")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SearchOrdersFilter getFilter() {
        return this.filter;
    }

    @JsonGetter(value="sort")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SearchOrdersSort getSort() {
        return this.sort;
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.sort);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchOrdersQuery)) {
            return false;
        }
        SearchOrdersQuery other = (SearchOrdersQuery)obj;
        return Objects.equals(this.filter, other.filter) && Objects.equals(this.sort, other.sort);
    }

    public String toString() {
        return "SearchOrdersQuery [filter=" + this.filter + ", sort=" + this.sort + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().filter(this.getFilter()).sort(this.getSort());
        return builder;
    }

    public static class Builder {
        private SearchOrdersFilter filter;
        private SearchOrdersSort sort;

        public Builder filter(SearchOrdersFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder sort(SearchOrdersSort sort) {
            this.sort = sort;
            return this;
        }

        public SearchOrdersQuery build() {
            return new SearchOrdersQuery(this.filter, this.sort);
        }
    }
}

