/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class SearchSubscriptionsFilter {
    private final OptionalNullable<List<String>> customerIds;
    private final OptionalNullable<List<String>> locationIds;
    private final OptionalNullable<List<String>> sourceNames;

    @JsonCreator
    public SearchSubscriptionsFilter(@JsonProperty(value="customer_ids") List<String> customerIds, @JsonProperty(value="location_ids") List<String> locationIds, @JsonProperty(value="source_names") List<String> sourceNames) {
        this.customerIds = OptionalNullable.of(customerIds);
        this.locationIds = OptionalNullable.of(locationIds);
        this.sourceNames = OptionalNullable.of(sourceNames);
    }

    protected SearchSubscriptionsFilter(OptionalNullable<List<String>> customerIds, OptionalNullable<List<String>> locationIds, OptionalNullable<List<String>> sourceNames) {
        this.customerIds = customerIds;
        this.locationIds = locationIds;
        this.sourceNames = sourceNames;
    }

    @JsonGetter(value="customer_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetCustomerIds() {
        return this.customerIds;
    }

    @JsonIgnore
    public List<String> getCustomerIds() {
        return (List)OptionalNullable.getFrom(this.customerIds);
    }

    @JsonGetter(value="location_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetLocationIds() {
        return this.locationIds;
    }

    @JsonIgnore
    public List<String> getLocationIds() {
        return (List)OptionalNullable.getFrom(this.locationIds);
    }

    @JsonGetter(value="source_names")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetSourceNames() {
        return this.sourceNames;
    }

    @JsonIgnore
    public List<String> getSourceNames() {
        return (List)OptionalNullable.getFrom(this.sourceNames);
    }

    public int hashCode() {
        return Objects.hash(this.customerIds, this.locationIds, this.sourceNames);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchSubscriptionsFilter)) {
            return false;
        }
        SearchSubscriptionsFilter other = (SearchSubscriptionsFilter)obj;
        return Objects.equals(this.customerIds, other.customerIds) && Objects.equals(this.locationIds, other.locationIds) && Objects.equals(this.sourceNames, other.sourceNames);
    }

    public String toString() {
        return "SearchSubscriptionsFilter [customerIds=" + this.customerIds + ", locationIds=" + this.locationIds + ", sourceNames=" + this.sourceNames + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.customerIds = this.internalGetCustomerIds();
        builder.locationIds = this.internalGetLocationIds();
        builder.sourceNames = this.internalGetSourceNames();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<List<String>> customerIds;
        private OptionalNullable<List<String>> locationIds;
        private OptionalNullable<List<String>> sourceNames;

        public Builder customerIds(List<String> customerIds) {
            this.customerIds = OptionalNullable.of(customerIds);
            return this;
        }

        public Builder unsetCustomerIds() {
            this.customerIds = null;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = OptionalNullable.of(locationIds);
            return this;
        }

        public Builder unsetLocationIds() {
            this.locationIds = null;
            return this;
        }

        public Builder sourceNames(List<String> sourceNames) {
            this.sourceNames = OptionalNullable.of(sourceNames);
            return this;
        }

        public Builder unsetSourceNames() {
            this.sourceNames = null;
            return this;
        }

        public SearchSubscriptionsFilter build() {
            return new SearchSubscriptionsFilter(this.customerIds, this.locationIds, this.sourceNames);
        }
    }
}

