/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.TeamMember;
import java.util.List;
import java.util.Objects;

public class SearchTeamMembersResponse {
    private HttpContext httpContext;
    private final List<TeamMember> teamMembers;
    private final String cursor;
    private final List<Error> errors;

    @JsonCreator
    public SearchTeamMembersResponse(@JsonProperty(value="team_members") List<TeamMember> teamMembers, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="errors") List<Error> errors) {
        this.teamMembers = teamMembers;
        this.cursor = cursor;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="team_members")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<TeamMember> getTeamMembers() {
        return this.teamMembers;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.teamMembers, this.cursor, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchTeamMembersResponse)) {
            return false;
        }
        SearchTeamMembersResponse other = (SearchTeamMembersResponse)obj;
        return Objects.equals(this.teamMembers, other.teamMembers) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "SearchTeamMembersResponse [teamMembers=" + this.teamMembers + ", cursor=" + this.cursor + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().teamMembers(this.getTeamMembers()).cursor(this.getCursor()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<TeamMember> teamMembers;
        private String cursor;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder teamMembers(List<TeamMember> teamMembers) {
            this.teamMembers = teamMembers;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public SearchTeamMembersResponse build() {
            SearchTeamMembersResponse model = new SearchTeamMembersResponse(this.teamMembers, this.cursor, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

