/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.TerminalCheckout;
import java.util.List;
import java.util.Objects;

public class SearchTerminalCheckoutsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<TerminalCheckout> checkouts;
    private final String cursor;

    @JsonCreator
    public SearchTerminalCheckoutsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="checkouts") List<TerminalCheckout> checkouts, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.checkouts = checkouts;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="checkouts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<TerminalCheckout> getCheckouts() {
        return this.checkouts;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.checkouts, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchTerminalCheckoutsResponse)) {
            return false;
        }
        SearchTerminalCheckoutsResponse other = (SearchTerminalCheckoutsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.checkouts, other.checkouts) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "SearchTerminalCheckoutsResponse [errors=" + this.errors + ", checkouts=" + this.checkouts + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).checkouts(this.getCheckouts()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<TerminalCheckout> checkouts;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder checkouts(List<TerminalCheckout> checkouts) {
            this.checkouts = checkouts;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public SearchTerminalCheckoutsResponse build() {
            SearchTerminalCheckoutsResponse model = new SearchTerminalCheckoutsResponse(this.errors, this.checkouts, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

