/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.TerminalRefund;
import java.util.List;
import java.util.Objects;

public class SearchTerminalRefundsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<TerminalRefund> refunds;
    private final String cursor;

    @JsonCreator
    public SearchTerminalRefundsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="refunds") List<TerminalRefund> refunds, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.refunds = refunds;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="refunds")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<TerminalRefund> getRefunds() {
        return this.refunds;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.refunds, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchTerminalRefundsResponse)) {
            return false;
        }
        SearchTerminalRefundsResponse other = (SearchTerminalRefundsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.refunds, other.refunds) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "SearchTerminalRefundsResponse [errors=" + this.errors + ", refunds=" + this.refunds + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).refunds(this.getRefunds()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<TerminalRefund> refunds;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder refunds(List<TerminalRefund> refunds) {
            this.refunds = refunds;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public SearchTerminalRefundsResponse build() {
            SearchTerminalRefundsResponse model = new SearchTerminalRefundsResponse(this.errors, this.refunds, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

