/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.FilterValue;
import java.util.Objects;

public class SegmentFilter {
    private final String serviceVariationId;
    private final FilterValue teamMemberIdFilter;

    @JsonCreator
    public SegmentFilter(@JsonProperty(value="service_variation_id") String serviceVariationId, @JsonProperty(value="team_member_id_filter") FilterValue teamMemberIdFilter) {
        this.serviceVariationId = serviceVariationId;
        this.teamMemberIdFilter = teamMemberIdFilter;
    }

    @JsonGetter(value="service_variation_id")
    public String getServiceVariationId() {
        return this.serviceVariationId;
    }

    @JsonGetter(value="team_member_id_filter")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public FilterValue getTeamMemberIdFilter() {
        return this.teamMemberIdFilter;
    }

    public int hashCode() {
        return Objects.hash(this.serviceVariationId, this.teamMemberIdFilter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SegmentFilter)) {
            return false;
        }
        SegmentFilter other = (SegmentFilter)obj;
        return Objects.equals(this.serviceVariationId, other.serviceVariationId) && Objects.equals(this.teamMemberIdFilter, other.teamMemberIdFilter);
    }

    public String toString() {
        return "SegmentFilter [serviceVariationId=" + this.serviceVariationId + ", teamMemberIdFilter=" + this.teamMemberIdFilter + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.serviceVariationId).teamMemberIdFilter(this.getTeamMemberIdFilter());
        return builder;
    }

    public static class Builder {
        private String serviceVariationId;
        private FilterValue teamMemberIdFilter;

        public Builder(String serviceVariationId) {
            this.serviceVariationId = serviceVariationId;
        }

        public Builder serviceVariationId(String serviceVariationId) {
            this.serviceVariationId = serviceVariationId;
            return this;
        }

        public Builder teamMemberIdFilter(FilterValue teamMemberIdFilter) {
            this.teamMemberIdFilter = teamMemberIdFilter;
            return this;
        }

        public SegmentFilter build() {
            return new SegmentFilter(this.serviceVariationId, this.teamMemberIdFilter);
        }
    }
}

