/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.SelectOption;
import java.util.List;
import java.util.Objects;

public class SelectOptions {
    private final String title;
    private final String body;
    private final List<SelectOption> options;
    private final SelectOption selectedOption;

    @JsonCreator
    public SelectOptions(@JsonProperty(value="title") String title, @JsonProperty(value="body") String body, @JsonProperty(value="options") List<SelectOption> options, @JsonProperty(value="selected_option") SelectOption selectedOption) {
        this.title = title;
        this.body = body;
        this.options = options;
        this.selectedOption = selectedOption;
    }

    @JsonGetter(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonGetter(value="body")
    public String getBody() {
        return this.body;
    }

    @JsonGetter(value="options")
    public List<SelectOption> getOptions() {
        return this.options;
    }

    @JsonGetter(value="selected_option")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SelectOption getSelectedOption() {
        return this.selectedOption;
    }

    public int hashCode() {
        return Objects.hash(this.title, this.body, this.options, this.selectedOption);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SelectOptions)) {
            return false;
        }
        SelectOptions other = (SelectOptions)obj;
        return Objects.equals(this.title, other.title) && Objects.equals(this.body, other.body) && Objects.equals(this.options, other.options) && Objects.equals(this.selectedOption, other.selectedOption);
    }

    public String toString() {
        return "SelectOptions [title=" + this.title + ", body=" + this.body + ", options=" + this.options + ", selectedOption=" + this.selectedOption + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.title, this.body, this.options).selectedOption(this.getSelectedOption());
        return builder;
    }

    public static class Builder {
        private String title;
        private String body;
        private List<SelectOption> options;
        private SelectOption selectedOption;

        public Builder(String title, String body, List<SelectOption> options) {
            this.title = title;
            this.body = body;
            this.options = options;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder options(List<SelectOption> options) {
            this.options = options;
            return this;
        }

        public Builder selectedOption(SelectOption selectedOption) {
            this.selectedOption = selectedOption;
            return this;
        }

        public SelectOptions build() {
            return new SelectOptions(this.title, this.body, this.options, this.selectedOption);
        }
    }
}

