/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Break;
import com.squareup.square.models.Money;
import com.squareup.square.models.ShiftWage;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class Shift {
    private final String id;
    private final OptionalNullable<String> employeeId;
    private final String locationId;
    private final OptionalNullable<String> timezone;
    private final String startAt;
    private final OptionalNullable<String> endAt;
    private final ShiftWage wage;
    private final OptionalNullable<List<Break>> breaks;
    private final String status;
    private final Integer version;
    private final String createdAt;
    private final String updatedAt;
    private final OptionalNullable<String> teamMemberId;
    private final Money declaredCashTipMoney;

    @JsonCreator
    public Shift(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="start_at") String startAt, @JsonProperty(value="id") String id, @JsonProperty(value="employee_id") String employeeId, @JsonProperty(value="timezone") String timezone, @JsonProperty(value="end_at") String endAt, @JsonProperty(value="wage") ShiftWage wage, @JsonProperty(value="breaks") List<Break> breaks, @JsonProperty(value="status") String status, @JsonProperty(value="version") Integer version, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="team_member_id") String teamMemberId, @JsonProperty(value="declared_cash_tip_money") Money declaredCashTipMoney) {
        this.id = id;
        this.employeeId = OptionalNullable.of((Object)employeeId);
        this.locationId = locationId;
        this.timezone = OptionalNullable.of((Object)timezone);
        this.startAt = startAt;
        this.endAt = OptionalNullable.of((Object)endAt);
        this.wage = wage;
        this.breaks = OptionalNullable.of(breaks);
        this.status = status;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.teamMemberId = OptionalNullable.of((Object)teamMemberId);
        this.declaredCashTipMoney = declaredCashTipMoney;
    }

    protected Shift(String locationId, String startAt, String id, OptionalNullable<String> employeeId, OptionalNullable<String> timezone, OptionalNullable<String> endAt, ShiftWage wage, OptionalNullable<List<Break>> breaks, String status, Integer version, String createdAt, String updatedAt, OptionalNullable<String> teamMemberId, Money declaredCashTipMoney) {
        this.id = id;
        this.employeeId = employeeId;
        this.locationId = locationId;
        this.timezone = timezone;
        this.startAt = startAt;
        this.endAt = endAt;
        this.wage = wage;
        this.breaks = breaks;
        this.status = status;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.teamMemberId = teamMemberId;
        this.declaredCashTipMoney = declaredCashTipMoney;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="employee_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEmployeeId() {
        return this.employeeId;
    }

    @JsonIgnore
    public String getEmployeeId() {
        return (String)OptionalNullable.getFrom(this.employeeId);
    }

    @JsonGetter(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="timezone")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTimezone() {
        return this.timezone;
    }

    @JsonIgnore
    public String getTimezone() {
        return (String)OptionalNullable.getFrom(this.timezone);
    }

    @JsonGetter(value="start_at")
    public String getStartAt() {
        return this.startAt;
    }

    @JsonGetter(value="end_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEndAt() {
        return this.endAt;
    }

    @JsonIgnore
    public String getEndAt() {
        return (String)OptionalNullable.getFrom(this.endAt);
    }

    @JsonGetter(value="wage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ShiftWage getWage() {
        return this.wage;
    }

    @JsonGetter(value="breaks")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<Break>> internalGetBreaks() {
        return this.breaks;
    }

    @JsonIgnore
    public List<Break> getBreaks() {
        return (List)OptionalNullable.getFrom(this.breaks);
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonIgnore
    public String getTeamMemberId() {
        return (String)OptionalNullable.getFrom(this.teamMemberId);
    }

    @JsonGetter(value="declared_cash_tip_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getDeclaredCashTipMoney() {
        return this.declaredCashTipMoney;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.employeeId, this.locationId, this.timezone, this.startAt, this.endAt, this.wage, this.breaks, this.status, this.version, this.createdAt, this.updatedAt, this.teamMemberId, this.declaredCashTipMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Shift)) {
            return false;
        }
        Shift other = (Shift)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.employeeId, other.employeeId) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.timezone, other.timezone) && Objects.equals(this.startAt, other.startAt) && Objects.equals(this.endAt, other.endAt) && Objects.equals(this.wage, other.wage) && Objects.equals(this.breaks, other.breaks) && Objects.equals(this.status, other.status) && Objects.equals(this.version, other.version) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.teamMemberId, other.teamMemberId) && Objects.equals(this.declaredCashTipMoney, other.declaredCashTipMoney);
    }

    public String toString() {
        return "Shift [locationId=" + this.locationId + ", startAt=" + this.startAt + ", id=" + this.id + ", employeeId=" + this.employeeId + ", timezone=" + this.timezone + ", endAt=" + this.endAt + ", wage=" + this.wage + ", breaks=" + this.breaks + ", status=" + this.status + ", version=" + this.version + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", teamMemberId=" + this.teamMemberId + ", declaredCashTipMoney=" + this.declaredCashTipMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.locationId, this.startAt).id(this.getId()).wage(this.getWage()).status(this.getStatus()).version(this.getVersion()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).declaredCashTipMoney(this.getDeclaredCashTipMoney());
        builder.employeeId = this.internalGetEmployeeId();
        builder.timezone = this.internalGetTimezone();
        builder.endAt = this.internalGetEndAt();
        builder.breaks = this.internalGetBreaks();
        builder.teamMemberId = this.internalGetTeamMemberId();
        return builder;
    }

    public static class Builder {
        private String locationId;
        private String startAt;
        private String id;
        private OptionalNullable<String> employeeId;
        private OptionalNullable<String> timezone;
        private OptionalNullable<String> endAt;
        private ShiftWage wage;
        private OptionalNullable<List<Break>> breaks;
        private String status;
        private Integer version;
        private String createdAt;
        private String updatedAt;
        private OptionalNullable<String> teamMemberId;
        private Money declaredCashTipMoney;

        public Builder(String locationId, String startAt) {
            this.locationId = locationId;
            this.startAt = startAt;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder startAt(String startAt) {
            this.startAt = startAt;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder employeeId(String employeeId) {
            this.employeeId = OptionalNullable.of((Object)employeeId);
            return this;
        }

        public Builder unsetEmployeeId() {
            this.employeeId = null;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = OptionalNullable.of((Object)timezone);
            return this;
        }

        public Builder unsetTimezone() {
            this.timezone = null;
            return this;
        }

        public Builder endAt(String endAt) {
            this.endAt = OptionalNullable.of((Object)endAt);
            return this;
        }

        public Builder unsetEndAt() {
            this.endAt = null;
            return this;
        }

        public Builder wage(ShiftWage wage) {
            this.wage = wage;
            return this;
        }

        public Builder breaks(List<Break> breaks) {
            this.breaks = OptionalNullable.of(breaks);
            return this;
        }

        public Builder unsetBreaks() {
            this.breaks = null;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = OptionalNullable.of((Object)teamMemberId);
            return this;
        }

        public Builder unsetTeamMemberId() {
            this.teamMemberId = null;
            return this;
        }

        public Builder declaredCashTipMoney(Money declaredCashTipMoney) {
            this.declaredCashTipMoney = declaredCashTipMoney;
            return this;
        }

        public Shift build() {
            return new Shift(this.locationId, this.startAt, this.id, this.employeeId, this.timezone, this.endAt, this.wage, this.breaks, this.status, this.version, this.createdAt, this.updatedAt, this.teamMemberId, this.declaredCashTipMoney);
        }
    }
}

