/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class Site {
    private final String id;
    private final OptionalNullable<String> siteTitle;
    private final OptionalNullable<String> domain;
    private final OptionalNullable<Boolean> isPublished;
    private final String createdAt;
    private final String updatedAt;

    @JsonCreator
    public Site(@JsonProperty(value="id") String id, @JsonProperty(value="site_title") String siteTitle, @JsonProperty(value="domain") String domain, @JsonProperty(value="is_published") Boolean isPublished, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt) {
        this.id = id;
        this.siteTitle = OptionalNullable.of((Object)siteTitle);
        this.domain = OptionalNullable.of((Object)domain);
        this.isPublished = OptionalNullable.of((Object)isPublished);
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    protected Site(String id, OptionalNullable<String> siteTitle, OptionalNullable<String> domain, OptionalNullable<Boolean> isPublished, String createdAt, String updatedAt) {
        this.id = id;
        this.siteTitle = siteTitle;
        this.domain = domain;
        this.isPublished = isPublished;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="site_title")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetSiteTitle() {
        return this.siteTitle;
    }

    @JsonIgnore
    public String getSiteTitle() {
        return (String)OptionalNullable.getFrom(this.siteTitle);
    }

    @JsonGetter(value="domain")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDomain() {
        return this.domain;
    }

    @JsonIgnore
    public String getDomain() {
        return (String)OptionalNullable.getFrom(this.domain);
    }

    @JsonGetter(value="is_published")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetIsPublished() {
        return this.isPublished;
    }

    @JsonIgnore
    public Boolean getIsPublished() {
        return (Boolean)OptionalNullable.getFrom(this.isPublished);
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.siteTitle, this.domain, this.isPublished, this.createdAt, this.updatedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Site)) {
            return false;
        }
        Site other = (Site)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.siteTitle, other.siteTitle) && Objects.equals(this.domain, other.domain) && Objects.equals(this.isPublished, other.isPublished) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt);
    }

    public String toString() {
        return "Site [id=" + this.id + ", siteTitle=" + this.siteTitle + ", domain=" + this.domain + ", isPublished=" + this.isPublished + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt());
        builder.siteTitle = this.internalGetSiteTitle();
        builder.domain = this.internalGetDomain();
        builder.isPublished = this.internalGetIsPublished();
        return builder;
    }

    public static class Builder {
        private String id;
        private OptionalNullable<String> siteTitle;
        private OptionalNullable<String> domain;
        private OptionalNullable<Boolean> isPublished;
        private String createdAt;
        private String updatedAt;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder siteTitle(String siteTitle) {
            this.siteTitle = OptionalNullable.of((Object)siteTitle);
            return this;
        }

        public Builder unsetSiteTitle() {
            this.siteTitle = null;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = OptionalNullable.of((Object)domain);
            return this;
        }

        public Builder unsetDomain() {
            this.domain = null;
            return this;
        }

        public Builder isPublished(Boolean isPublished) {
            this.isPublished = OptionalNullable.of((Object)isPublished);
            return this;
        }

        public Builder unsetIsPublished() {
            this.isPublished = null;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Site build() {
            return new Site(this.id, this.siteTitle, this.domain, this.isPublished, this.createdAt, this.updatedAt);
        }
    }
}

