/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class SourceApplication {
    private final String product;
    private final OptionalNullable<String> applicationId;
    private final OptionalNullable<String> name;

    @JsonCreator
    public SourceApplication(@JsonProperty(value="product") String product, @JsonProperty(value="application_id") String applicationId, @JsonProperty(value="name") String name) {
        this.product = product;
        this.applicationId = OptionalNullable.of((Object)applicationId);
        this.name = OptionalNullable.of((Object)name);
    }

    protected SourceApplication(String product, OptionalNullable<String> applicationId, OptionalNullable<String> name) {
        this.product = product;
        this.applicationId = applicationId;
        this.name = name;
    }

    @JsonGetter(value="product")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getProduct() {
        return this.product;
    }

    @JsonGetter(value="application_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetApplicationId() {
        return this.applicationId;
    }

    @JsonIgnore
    public String getApplicationId() {
        return (String)OptionalNullable.getFrom(this.applicationId);
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    public int hashCode() {
        return Objects.hash(this.product, this.applicationId, this.name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SourceApplication)) {
            return false;
        }
        SourceApplication other = (SourceApplication)obj;
        return Objects.equals(this.product, other.product) && Objects.equals(this.applicationId, other.applicationId) && Objects.equals(this.name, other.name);
    }

    public String toString() {
        return "SourceApplication [product=" + this.product + ", applicationId=" + this.applicationId + ", name=" + this.name + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().product(this.getProduct());
        builder.applicationId = this.internalGetApplicationId();
        builder.name = this.internalGetName();
        return builder;
    }

    public static class Builder {
        private String product;
        private OptionalNullable<String> applicationId;
        private OptionalNullable<String> name;

        public Builder product(String product) {
            this.product = product;
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = OptionalNullable.of((Object)applicationId);
            return this;
        }

        public Builder unsetApplicationId() {
            this.applicationId = null;
            return this;
        }

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public SourceApplication build() {
            return new SourceApplication(this.product, this.applicationId, this.name);
        }
    }
}

