/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Error;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class SquareAccountDetails {
    private final OptionalNullable<String> paymentSourceToken;
    private final OptionalNullable<List<Error>> errors;

    @JsonCreator
    public SquareAccountDetails(@JsonProperty(value="payment_source_token") String paymentSourceToken, @JsonProperty(value="errors") List<Error> errors) {
        this.paymentSourceToken = OptionalNullable.of((Object)paymentSourceToken);
        this.errors = OptionalNullable.of(errors);
    }

    protected SquareAccountDetails(OptionalNullable<String> paymentSourceToken, OptionalNullable<List<Error>> errors) {
        this.paymentSourceToken = paymentSourceToken;
        this.errors = errors;
    }

    @JsonGetter(value="payment_source_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPaymentSourceToken() {
        return this.paymentSourceToken;
    }

    @JsonIgnore
    public String getPaymentSourceToken() {
        return (String)OptionalNullable.getFrom(this.paymentSourceToken);
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<Error>> internalGetErrors() {
        return this.errors;
    }

    @JsonIgnore
    public List<Error> getErrors() {
        return (List)OptionalNullable.getFrom(this.errors);
    }

    public int hashCode() {
        return Objects.hash(this.paymentSourceToken, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SquareAccountDetails)) {
            return false;
        }
        SquareAccountDetails other = (SquareAccountDetails)obj;
        return Objects.equals(this.paymentSourceToken, other.paymentSourceToken) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "SquareAccountDetails [paymentSourceToken=" + this.paymentSourceToken + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.paymentSourceToken = this.internalGetPaymentSourceToken();
        builder.errors = this.internalGetErrors();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> paymentSourceToken;
        private OptionalNullable<List<Error>> errors;

        public Builder paymentSourceToken(String paymentSourceToken) {
            this.paymentSourceToken = OptionalNullable.of((Object)paymentSourceToken);
            return this;
        }

        public Builder unsetPaymentSourceToken() {
            this.paymentSourceToken = null;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = OptionalNullable.of(errors);
            return this;
        }

        public Builder unsetErrors() {
            this.errors = null;
            return this;
        }

        public SquareAccountDetails build() {
            return new SquareAccountDetails(this.paymentSourceToken, this.errors);
        }
    }
}

