/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.StandardUnitDescription;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class StandardUnitDescriptionGroup {
    private final OptionalNullable<List<StandardUnitDescription>> standardUnitDescriptions;
    private final OptionalNullable<String> languageCode;

    @JsonCreator
    public StandardUnitDescriptionGroup(@JsonProperty(value="standard_unit_descriptions") List<StandardUnitDescription> standardUnitDescriptions, @JsonProperty(value="language_code") String languageCode) {
        this.standardUnitDescriptions = OptionalNullable.of(standardUnitDescriptions);
        this.languageCode = OptionalNullable.of((Object)languageCode);
    }

    protected StandardUnitDescriptionGroup(OptionalNullable<List<StandardUnitDescription>> standardUnitDescriptions, OptionalNullable<String> languageCode) {
        this.standardUnitDescriptions = standardUnitDescriptions;
        this.languageCode = languageCode;
    }

    @JsonGetter(value="standard_unit_descriptions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<StandardUnitDescription>> internalGetStandardUnitDescriptions() {
        return this.standardUnitDescriptions;
    }

    @JsonIgnore
    public List<StandardUnitDescription> getStandardUnitDescriptions() {
        return (List)OptionalNullable.getFrom(this.standardUnitDescriptions);
    }

    @JsonGetter(value="language_code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLanguageCode() {
        return this.languageCode;
    }

    @JsonIgnore
    public String getLanguageCode() {
        return (String)OptionalNullable.getFrom(this.languageCode);
    }

    public int hashCode() {
        return Objects.hash(this.standardUnitDescriptions, this.languageCode);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardUnitDescriptionGroup)) {
            return false;
        }
        StandardUnitDescriptionGroup other = (StandardUnitDescriptionGroup)obj;
        return Objects.equals(this.standardUnitDescriptions, other.standardUnitDescriptions) && Objects.equals(this.languageCode, other.languageCode);
    }

    public String toString() {
        return "StandardUnitDescriptionGroup [standardUnitDescriptions=" + this.standardUnitDescriptions + ", languageCode=" + this.languageCode + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.standardUnitDescriptions = this.internalGetStandardUnitDescriptions();
        builder.languageCode = this.internalGetLanguageCode();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<List<StandardUnitDescription>> standardUnitDescriptions;
        private OptionalNullable<String> languageCode;

        public Builder standardUnitDescriptions(List<StandardUnitDescription> standardUnitDescriptions) {
            this.standardUnitDescriptions = OptionalNullable.of(standardUnitDescriptions);
            return this;
        }

        public Builder unsetStandardUnitDescriptions() {
            this.standardUnitDescriptions = null;
            return this;
        }

        public Builder languageCode(String languageCode) {
            this.languageCode = OptionalNullable.of((Object)languageCode);
            return this;
        }

        public Builder unsetLanguageCode() {
            this.languageCode = null;
            return this;
        }

        public StandardUnitDescriptionGroup build() {
            return new StandardUnitDescriptionGroup(this.standardUnitDescriptions, this.languageCode);
        }
    }
}

