/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import com.squareup.square.models.Phase;
import com.squareup.square.models.SubscriptionAction;
import com.squareup.square.models.SubscriptionSource;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class Subscription {
    private final String id;
    private final String locationId;
    private final String planVariationId;
    private final String customerId;
    private final String startDate;
    private final OptionalNullable<String> canceledDate;
    private final String chargedThroughDate;
    private final String status;
    private final OptionalNullable<String> taxPercentage;
    private final List<String> invoiceIds;
    private final Money priceOverrideMoney;
    private final Long version;
    private final String createdAt;
    private final OptionalNullable<String> cardId;
    private final String timezone;
    private final SubscriptionSource source;
    private final OptionalNullable<List<SubscriptionAction>> actions;
    private final Integer monthlyBillingAnchorDate;
    private final List<Phase> phases;

    @JsonCreator
    public Subscription(@JsonProperty(value="id") String id, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="plan_variation_id") String planVariationId, @JsonProperty(value="customer_id") String customerId, @JsonProperty(value="start_date") String startDate, @JsonProperty(value="canceled_date") String canceledDate, @JsonProperty(value="charged_through_date") String chargedThroughDate, @JsonProperty(value="status") String status, @JsonProperty(value="tax_percentage") String taxPercentage, @JsonProperty(value="invoice_ids") List<String> invoiceIds, @JsonProperty(value="price_override_money") Money priceOverrideMoney, @JsonProperty(value="version") Long version, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="card_id") String cardId, @JsonProperty(value="timezone") String timezone, @JsonProperty(value="source") SubscriptionSource source, @JsonProperty(value="actions") List<SubscriptionAction> actions, @JsonProperty(value="monthly_billing_anchor_date") Integer monthlyBillingAnchorDate, @JsonProperty(value="phases") List<Phase> phases) {
        this.id = id;
        this.locationId = locationId;
        this.planVariationId = planVariationId;
        this.customerId = customerId;
        this.startDate = startDate;
        this.canceledDate = OptionalNullable.of((Object)canceledDate);
        this.chargedThroughDate = chargedThroughDate;
        this.status = status;
        this.taxPercentage = OptionalNullable.of((Object)taxPercentage);
        this.invoiceIds = invoiceIds;
        this.priceOverrideMoney = priceOverrideMoney;
        this.version = version;
        this.createdAt = createdAt;
        this.cardId = OptionalNullable.of((Object)cardId);
        this.timezone = timezone;
        this.source = source;
        this.actions = OptionalNullable.of(actions);
        this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
        this.phases = phases;
    }

    protected Subscription(String id, String locationId, String planVariationId, String customerId, String startDate, OptionalNullable<String> canceledDate, String chargedThroughDate, String status, OptionalNullable<String> taxPercentage, List<String> invoiceIds, Money priceOverrideMoney, Long version, String createdAt, OptionalNullable<String> cardId, String timezone, SubscriptionSource source, OptionalNullable<List<SubscriptionAction>> actions, Integer monthlyBillingAnchorDate, List<Phase> phases) {
        this.id = id;
        this.locationId = locationId;
        this.planVariationId = planVariationId;
        this.customerId = customerId;
        this.startDate = startDate;
        this.canceledDate = canceledDate;
        this.chargedThroughDate = chargedThroughDate;
        this.status = status;
        this.taxPercentage = taxPercentage;
        this.invoiceIds = invoiceIds;
        this.priceOverrideMoney = priceOverrideMoney;
        this.version = version;
        this.createdAt = createdAt;
        this.cardId = cardId;
        this.timezone = timezone;
        this.source = source;
        this.actions = actions;
        this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
        this.phases = phases;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="plan_variation_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPlanVariationId() {
        return this.planVariationId;
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonGetter(value="start_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStartDate() {
        return this.startDate;
    }

    @JsonGetter(value="canceled_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCanceledDate() {
        return this.canceledDate;
    }

    @JsonIgnore
    public String getCanceledDate() {
        return (String)OptionalNullable.getFrom(this.canceledDate);
    }

    @JsonGetter(value="charged_through_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getChargedThroughDate() {
        return this.chargedThroughDate;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="tax_percentage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTaxPercentage() {
        return this.taxPercentage;
    }

    @JsonIgnore
    public String getTaxPercentage() {
        return (String)OptionalNullable.getFrom(this.taxPercentage);
    }

    @JsonGetter(value="invoice_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getInvoiceIds() {
        return this.invoiceIds;
    }

    @JsonGetter(value="price_override_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getPriceOverrideMoney() {
        return this.priceOverrideMoney;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getVersion() {
        return this.version;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="card_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCardId() {
        return this.cardId;
    }

    @JsonIgnore
    public String getCardId() {
        return (String)OptionalNullable.getFrom(this.cardId);
    }

    @JsonGetter(value="timezone")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTimezone() {
        return this.timezone;
    }

    @JsonGetter(value="source")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SubscriptionSource getSource() {
        return this.source;
    }

    @JsonGetter(value="actions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<SubscriptionAction>> internalGetActions() {
        return this.actions;
    }

    @JsonIgnore
    public List<SubscriptionAction> getActions() {
        return (List)OptionalNullable.getFrom(this.actions);
    }

    @JsonGetter(value="monthly_billing_anchor_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMonthlyBillingAnchorDate() {
        return this.monthlyBillingAnchorDate;
    }

    @JsonGetter(value="phases")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Phase> getPhases() {
        return this.phases;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.locationId, this.planVariationId, this.customerId, this.startDate, this.canceledDate, this.chargedThroughDate, this.status, this.taxPercentage, this.invoiceIds, this.priceOverrideMoney, this.version, this.createdAt, this.cardId, this.timezone, this.source, this.actions, this.monthlyBillingAnchorDate, this.phases);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.planVariationId, other.planVariationId) && Objects.equals(this.customerId, other.customerId) && Objects.equals(this.startDate, other.startDate) && Objects.equals(this.canceledDate, other.canceledDate) && Objects.equals(this.chargedThroughDate, other.chargedThroughDate) && Objects.equals(this.status, other.status) && Objects.equals(this.taxPercentage, other.taxPercentage) && Objects.equals(this.invoiceIds, other.invoiceIds) && Objects.equals(this.priceOverrideMoney, other.priceOverrideMoney) && Objects.equals(this.version, other.version) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.cardId, other.cardId) && Objects.equals(this.timezone, other.timezone) && Objects.equals(this.source, other.source) && Objects.equals(this.actions, other.actions) && Objects.equals(this.monthlyBillingAnchorDate, other.monthlyBillingAnchorDate) && Objects.equals(this.phases, other.phases);
    }

    public String toString() {
        return "Subscription [id=" + this.id + ", locationId=" + this.locationId + ", planVariationId=" + this.planVariationId + ", customerId=" + this.customerId + ", startDate=" + this.startDate + ", canceledDate=" + this.canceledDate + ", chargedThroughDate=" + this.chargedThroughDate + ", status=" + this.status + ", taxPercentage=" + this.taxPercentage + ", invoiceIds=" + this.invoiceIds + ", priceOverrideMoney=" + this.priceOverrideMoney + ", version=" + this.version + ", createdAt=" + this.createdAt + ", cardId=" + this.cardId + ", timezone=" + this.timezone + ", source=" + this.source + ", actions=" + this.actions + ", monthlyBillingAnchorDate=" + this.monthlyBillingAnchorDate + ", phases=" + this.phases + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).locationId(this.getLocationId()).planVariationId(this.getPlanVariationId()).customerId(this.getCustomerId()).startDate(this.getStartDate()).chargedThroughDate(this.getChargedThroughDate()).status(this.getStatus()).invoiceIds(this.getInvoiceIds()).priceOverrideMoney(this.getPriceOverrideMoney()).version(this.getVersion()).createdAt(this.getCreatedAt()).timezone(this.getTimezone()).source(this.getSource()).monthlyBillingAnchorDate(this.getMonthlyBillingAnchorDate()).phases(this.getPhases());
        builder.canceledDate = this.internalGetCanceledDate();
        builder.taxPercentage = this.internalGetTaxPercentage();
        builder.cardId = this.internalGetCardId();
        builder.actions = this.internalGetActions();
        return builder;
    }

    public static class Builder {
        private String id;
        private String locationId;
        private String planVariationId;
        private String customerId;
        private String startDate;
        private OptionalNullable<String> canceledDate;
        private String chargedThroughDate;
        private String status;
        private OptionalNullable<String> taxPercentage;
        private List<String> invoiceIds;
        private Money priceOverrideMoney;
        private Long version;
        private String createdAt;
        private OptionalNullable<String> cardId;
        private String timezone;
        private SubscriptionSource source;
        private OptionalNullable<List<SubscriptionAction>> actions;
        private Integer monthlyBillingAnchorDate;
        private List<Phase> phases;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder planVariationId(String planVariationId) {
            this.planVariationId = planVariationId;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder canceledDate(String canceledDate) {
            this.canceledDate = OptionalNullable.of((Object)canceledDate);
            return this;
        }

        public Builder unsetCanceledDate() {
            this.canceledDate = null;
            return this;
        }

        public Builder chargedThroughDate(String chargedThroughDate) {
            this.chargedThroughDate = chargedThroughDate;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder taxPercentage(String taxPercentage) {
            this.taxPercentage = OptionalNullable.of((Object)taxPercentage);
            return this;
        }

        public Builder unsetTaxPercentage() {
            this.taxPercentage = null;
            return this;
        }

        public Builder invoiceIds(List<String> invoiceIds) {
            this.invoiceIds = invoiceIds;
            return this;
        }

        public Builder priceOverrideMoney(Money priceOverrideMoney) {
            this.priceOverrideMoney = priceOverrideMoney;
            return this;
        }

        public Builder version(Long version) {
            this.version = version;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder cardId(String cardId) {
            this.cardId = OptionalNullable.of((Object)cardId);
            return this;
        }

        public Builder unsetCardId() {
            this.cardId = null;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder source(SubscriptionSource source) {
            this.source = source;
            return this;
        }

        public Builder actions(List<SubscriptionAction> actions) {
            this.actions = OptionalNullable.of(actions);
            return this;
        }

        public Builder unsetActions() {
            this.actions = null;
            return this;
        }

        public Builder monthlyBillingAnchorDate(Integer monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
            return this;
        }

        public Builder phases(List<Phase> phases) {
            this.phases = phases;
            return this;
        }

        public Subscription build() {
            return new Subscription(this.id, this.locationId, this.planVariationId, this.customerId, this.startDate, this.canceledDate, this.chargedThroughDate, this.status, this.taxPercentage, this.invoiceIds, this.priceOverrideMoney, this.version, this.createdAt, this.cardId, this.timezone, this.source, this.actions, this.monthlyBillingAnchorDate, this.phases);
        }
    }
}

