/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Phase;
import com.squareup.square.models.SubscriptionEventInfo;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class SubscriptionEvent {
    private final String id;
    private final String subscriptionEventType;
    private final String effectiveDate;
    private final Integer monthlyBillingAnchorDate;
    private final SubscriptionEventInfo info;
    private final OptionalNullable<List<Phase>> phases;
    private final String planVariationId;

    @JsonCreator
    public SubscriptionEvent(@JsonProperty(value="id") String id, @JsonProperty(value="subscription_event_type") String subscriptionEventType, @JsonProperty(value="effective_date") String effectiveDate, @JsonProperty(value="plan_variation_id") String planVariationId, @JsonProperty(value="monthly_billing_anchor_date") Integer monthlyBillingAnchorDate, @JsonProperty(value="info") SubscriptionEventInfo info, @JsonProperty(value="phases") List<Phase> phases) {
        this.id = id;
        this.subscriptionEventType = subscriptionEventType;
        this.effectiveDate = effectiveDate;
        this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
        this.info = info;
        this.phases = OptionalNullable.of(phases);
        this.planVariationId = planVariationId;
    }

    protected SubscriptionEvent(String id, String subscriptionEventType, String effectiveDate, String planVariationId, Integer monthlyBillingAnchorDate, SubscriptionEventInfo info, OptionalNullable<List<Phase>> phases) {
        this.id = id;
        this.subscriptionEventType = subscriptionEventType;
        this.effectiveDate = effectiveDate;
        this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
        this.info = info;
        this.phases = phases;
        this.planVariationId = planVariationId;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="subscription_event_type")
    public String getSubscriptionEventType() {
        return this.subscriptionEventType;
    }

    @JsonGetter(value="effective_date")
    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    @JsonGetter(value="monthly_billing_anchor_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMonthlyBillingAnchorDate() {
        return this.monthlyBillingAnchorDate;
    }

    @JsonGetter(value="info")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SubscriptionEventInfo getInfo() {
        return this.info;
    }

    @JsonGetter(value="phases")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<Phase>> internalGetPhases() {
        return this.phases;
    }

    @JsonIgnore
    public List<Phase> getPhases() {
        return (List)OptionalNullable.getFrom(this.phases);
    }

    @JsonGetter(value="plan_variation_id")
    public String getPlanVariationId() {
        return this.planVariationId;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.subscriptionEventType, this.effectiveDate, this.monthlyBillingAnchorDate, this.info, this.phases, this.planVariationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SubscriptionEvent)) {
            return false;
        }
        SubscriptionEvent other = (SubscriptionEvent)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.subscriptionEventType, other.subscriptionEventType) && Objects.equals(this.effectiveDate, other.effectiveDate) && Objects.equals(this.monthlyBillingAnchorDate, other.monthlyBillingAnchorDate) && Objects.equals(this.info, other.info) && Objects.equals(this.phases, other.phases) && Objects.equals(this.planVariationId, other.planVariationId);
    }

    public String toString() {
        return "SubscriptionEvent [id=" + this.id + ", subscriptionEventType=" + this.subscriptionEventType + ", effectiveDate=" + this.effectiveDate + ", planVariationId=" + this.planVariationId + ", monthlyBillingAnchorDate=" + this.monthlyBillingAnchorDate + ", info=" + this.info + ", phases=" + this.phases + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.id, this.subscriptionEventType, this.effectiveDate, this.planVariationId).monthlyBillingAnchorDate(this.getMonthlyBillingAnchorDate()).info(this.getInfo());
        builder.phases = this.internalGetPhases();
        return builder;
    }

    public static class Builder {
        private String id;
        private String subscriptionEventType;
        private String effectiveDate;
        private String planVariationId;
        private Integer monthlyBillingAnchorDate;
        private SubscriptionEventInfo info;
        private OptionalNullable<List<Phase>> phases;

        public Builder(String id, String subscriptionEventType, String effectiveDate, String planVariationId) {
            this.id = id;
            this.subscriptionEventType = subscriptionEventType;
            this.effectiveDate = effectiveDate;
            this.planVariationId = planVariationId;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder subscriptionEventType(String subscriptionEventType) {
            this.subscriptionEventType = subscriptionEventType;
            return this;
        }

        public Builder effectiveDate(String effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public Builder planVariationId(String planVariationId) {
            this.planVariationId = planVariationId;
            return this;
        }

        public Builder monthlyBillingAnchorDate(Integer monthlyBillingAnchorDate) {
            this.monthlyBillingAnchorDate = monthlyBillingAnchorDate;
            return this;
        }

        public Builder info(SubscriptionEventInfo info) {
            this.info = info;
            return this;
        }

        public Builder phases(List<Phase> phases) {
            this.phases = OptionalNullable.of(phases);
            return this;
        }

        public Builder unsetPhases() {
            this.phases = null;
            return this;
        }

        public SubscriptionEvent build() {
            return new SubscriptionEvent(this.id, this.subscriptionEventType, this.effectiveDate, this.planVariationId, this.monthlyBillingAnchorDate, this.info, this.phases);
        }
    }
}

