/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class SubscriptionTestResult {
    private final String id;
    private final OptionalNullable<Integer> statusCode;
    private final OptionalNullable<String> payload;
    private final String createdAt;
    private final String updatedAt;

    @JsonCreator
    public SubscriptionTestResult(@JsonProperty(value="id") String id, @JsonProperty(value="status_code") Integer statusCode, @JsonProperty(value="payload") String payload, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt) {
        this.id = id;
        this.statusCode = OptionalNullable.of((Object)statusCode);
        this.payload = OptionalNullable.of((Object)payload);
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    protected SubscriptionTestResult(String id, OptionalNullable<Integer> statusCode, OptionalNullable<String> payload, String createdAt, String updatedAt) {
        this.id = id;
        this.statusCode = statusCode;
        this.payload = payload;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="status_code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetStatusCode() {
        return this.statusCode;
    }

    @JsonIgnore
    public Integer getStatusCode() {
        return (Integer)OptionalNullable.getFrom(this.statusCode);
    }

    @JsonGetter(value="payload")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPayload() {
        return this.payload;
    }

    @JsonIgnore
    public String getPayload() {
        return (String)OptionalNullable.getFrom(this.payload);
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.statusCode, this.payload, this.createdAt, this.updatedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SubscriptionTestResult)) {
            return false;
        }
        SubscriptionTestResult other = (SubscriptionTestResult)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.statusCode, other.statusCode) && Objects.equals(this.payload, other.payload) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt);
    }

    public String toString() {
        return "SubscriptionTestResult [id=" + this.id + ", statusCode=" + this.statusCode + ", payload=" + this.payload + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt());
        builder.statusCode = this.internalGetStatusCode();
        builder.payload = this.internalGetPayload();
        return builder;
    }

    public static class Builder {
        private String id;
        private OptionalNullable<Integer> statusCode;
        private OptionalNullable<String> payload;
        private String createdAt;
        private String updatedAt;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder statusCode(Integer statusCode) {
            this.statusCode = OptionalNullable.of((Object)statusCode);
            return this;
        }

        public Builder unsetStatusCode() {
            this.statusCode = null;
            return this;
        }

        public Builder payload(String payload) {
            this.payload = OptionalNullable.of((Object)payload);
            return this;
        }

        public Builder unsetPayload() {
            this.payload = null;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public SubscriptionTestResult build() {
            return new SubscriptionTestResult(this.id, this.statusCode, this.payload, this.createdAt, this.updatedAt);
        }
    }
}

