/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class TeamMemberAssignedLocations {
    private final String assignmentType;
    private final OptionalNullable<List<String>> locationIds;

    @JsonCreator
    public TeamMemberAssignedLocations(@JsonProperty(value="assignment_type") String assignmentType, @JsonProperty(value="location_ids") List<String> locationIds) {
        this.assignmentType = assignmentType;
        this.locationIds = OptionalNullable.of(locationIds);
    }

    protected TeamMemberAssignedLocations(String assignmentType, OptionalNullable<List<String>> locationIds) {
        this.assignmentType = assignmentType;
        this.locationIds = locationIds;
    }

    @JsonGetter(value="assignment_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAssignmentType() {
        return this.assignmentType;
    }

    @JsonGetter(value="location_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetLocationIds() {
        return this.locationIds;
    }

    @JsonIgnore
    public List<String> getLocationIds() {
        return (List)OptionalNullable.getFrom(this.locationIds);
    }

    public int hashCode() {
        return Objects.hash(this.assignmentType, this.locationIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TeamMemberAssignedLocations)) {
            return false;
        }
        TeamMemberAssignedLocations other = (TeamMemberAssignedLocations)obj;
        return Objects.equals(this.assignmentType, other.assignmentType) && Objects.equals(this.locationIds, other.locationIds);
    }

    public String toString() {
        return "TeamMemberAssignedLocations [assignmentType=" + this.assignmentType + ", locationIds=" + this.locationIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().assignmentType(this.getAssignmentType());
        builder.locationIds = this.internalGetLocationIds();
        return builder;
    }

    public static class Builder {
        private String assignmentType;
        private OptionalNullable<List<String>> locationIds;

        public Builder assignmentType(String assignmentType) {
            this.assignmentType = assignmentType;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = OptionalNullable.of(locationIds);
            return this;
        }

        public Builder unsetLocationIds() {
            this.locationIds = null;
            return this;
        }

        public TeamMemberAssignedLocations build() {
            return new TeamMemberAssignedLocations(this.assignmentType, this.locationIds);
        }
    }
}

