/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class TeamMemberBookingProfile {
    private final String teamMemberId;
    private final String description;
    private final String displayName;
    private final OptionalNullable<Boolean> isBookable;
    private final String profileImageUrl;

    @JsonCreator
    public TeamMemberBookingProfile(@JsonProperty(value="team_member_id") String teamMemberId, @JsonProperty(value="description") String description, @JsonProperty(value="display_name") String displayName, @JsonProperty(value="is_bookable") Boolean isBookable, @JsonProperty(value="profile_image_url") String profileImageUrl) {
        this.teamMemberId = teamMemberId;
        this.description = description;
        this.displayName = displayName;
        this.isBookable = OptionalNullable.of((Object)isBookable);
        this.profileImageUrl = profileImageUrl;
    }

    protected TeamMemberBookingProfile(String teamMemberId, String description, String displayName, OptionalNullable<Boolean> isBookable, String profileImageUrl) {
        this.teamMemberId = teamMemberId;
        this.description = description;
        this.displayName = displayName;
        this.isBookable = isBookable;
        this.profileImageUrl = profileImageUrl;
    }

    @JsonGetter(value="team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonGetter(value="display_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonGetter(value="is_bookable")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetIsBookable() {
        return this.isBookable;
    }

    @JsonIgnore
    public Boolean getIsBookable() {
        return (Boolean)OptionalNullable.getFrom(this.isBookable);
    }

    @JsonGetter(value="profile_image_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getProfileImageUrl() {
        return this.profileImageUrl;
    }

    public int hashCode() {
        return Objects.hash(this.teamMemberId, this.description, this.displayName, this.isBookable, this.profileImageUrl);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TeamMemberBookingProfile)) {
            return false;
        }
        TeamMemberBookingProfile other = (TeamMemberBookingProfile)obj;
        return Objects.equals(this.teamMemberId, other.teamMemberId) && Objects.equals(this.description, other.description) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.isBookable, other.isBookable) && Objects.equals(this.profileImageUrl, other.profileImageUrl);
    }

    public String toString() {
        return "TeamMemberBookingProfile [teamMemberId=" + this.teamMemberId + ", description=" + this.description + ", displayName=" + this.displayName + ", isBookable=" + this.isBookable + ", profileImageUrl=" + this.profileImageUrl + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().teamMemberId(this.getTeamMemberId()).description(this.getDescription()).displayName(this.getDisplayName()).profileImageUrl(this.getProfileImageUrl());
        builder.isBookable = this.internalGetIsBookable();
        return builder;
    }

    public static class Builder {
        private String teamMemberId;
        private String description;
        private String displayName;
        private OptionalNullable<Boolean> isBookable;
        private String profileImageUrl;

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder isBookable(Boolean isBookable) {
            this.isBookable = OptionalNullable.of((Object)isBookable);
            return this;
        }

        public Builder unsetIsBookable() {
            this.isBookable = null;
            return this;
        }

        public Builder profileImageUrl(String profileImageUrl) {
            this.profileImageUrl = profileImageUrl;
            return this;
        }

        public TeamMemberBookingProfile build() {
            return new TeamMemberBookingProfile(this.teamMemberId, this.description, this.displayName, this.isBookable, this.profileImageUrl);
        }
    }
}

