/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.TimeRange;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class TerminalRefundQueryFilter {
    private final OptionalNullable<String> deviceId;
    private final TimeRange createdAt;
    private final OptionalNullable<String> status;

    @JsonCreator
    public TerminalRefundQueryFilter(@JsonProperty(value="device_id") String deviceId, @JsonProperty(value="created_at") TimeRange createdAt, @JsonProperty(value="status") String status) {
        this.deviceId = OptionalNullable.of((Object)deviceId);
        this.createdAt = createdAt;
        this.status = OptionalNullable.of((Object)status);
    }

    protected TerminalRefundQueryFilter(OptionalNullable<String> deviceId, TimeRange createdAt, OptionalNullable<String> status) {
        this.deviceId = deviceId;
        this.createdAt = createdAt;
        this.status = status;
    }

    @JsonGetter(value="device_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDeviceId() {
        return this.deviceId;
    }

    @JsonIgnore
    public String getDeviceId() {
        return (String)OptionalNullable.getFrom(this.deviceId);
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TimeRange getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetStatus() {
        return this.status;
    }

    @JsonIgnore
    public String getStatus() {
        return (String)OptionalNullable.getFrom(this.status);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.createdAt, this.status);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TerminalRefundQueryFilter)) {
            return false;
        }
        TerminalRefundQueryFilter other = (TerminalRefundQueryFilter)obj;
        return Objects.equals(this.deviceId, other.deviceId) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.status, other.status);
    }

    public String toString() {
        return "TerminalRefundQueryFilter [deviceId=" + this.deviceId + ", createdAt=" + this.createdAt + ", status=" + this.status + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().createdAt(this.getCreatedAt());
        builder.deviceId = this.internalGetDeviceId();
        builder.status = this.internalGetStatus();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> deviceId;
        private TimeRange createdAt;
        private OptionalNullable<String> status;

        public Builder deviceId(String deviceId) {
            this.deviceId = OptionalNullable.of((Object)deviceId);
            return this;
        }

        public Builder unsetDeviceId() {
            this.deviceId = null;
            return this;
        }

        public Builder createdAt(TimeRange createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder status(String status) {
            this.status = OptionalNullable.of((Object)status);
            return this;
        }

        public Builder unsetStatus() {
            this.status = null;
            return this;
        }

        public TerminalRefundQueryFilter build() {
            return new TerminalRefundQueryFilter(this.deviceId, this.createdAt, this.status);
        }
    }
}

