/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class TimeRange {
    private final OptionalNullable<String> startAt;
    private final OptionalNullable<String> endAt;

    @JsonCreator
    public TimeRange(@JsonProperty(value="start_at") String startAt, @JsonProperty(value="end_at") String endAt) {
        this.startAt = OptionalNullable.of((Object)startAt);
        this.endAt = OptionalNullable.of((Object)endAt);
    }

    protected TimeRange(OptionalNullable<String> startAt, OptionalNullable<String> endAt) {
        this.startAt = startAt;
        this.endAt = endAt;
    }

    @JsonGetter(value="start_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetStartAt() {
        return this.startAt;
    }

    @JsonIgnore
    public String getStartAt() {
        return (String)OptionalNullable.getFrom(this.startAt);
    }

    @JsonGetter(value="end_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEndAt() {
        return this.endAt;
    }

    @JsonIgnore
    public String getEndAt() {
        return (String)OptionalNullable.getFrom(this.endAt);
    }

    public int hashCode() {
        return Objects.hash(this.startAt, this.endAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TimeRange)) {
            return false;
        }
        TimeRange other = (TimeRange)obj;
        return Objects.equals(this.startAt, other.startAt) && Objects.equals(this.endAt, other.endAt);
    }

    public String toString() {
        return "TimeRange [startAt=" + this.startAt + ", endAt=" + this.endAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.startAt = this.internalGetStartAt();
        builder.endAt = this.internalGetEndAt();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> startAt;
        private OptionalNullable<String> endAt;

        public Builder startAt(String startAt) {
            this.startAt = OptionalNullable.of((Object)startAt);
            return this;
        }

        public Builder unsetStartAt() {
            this.startAt = null;
            return this;
        }

        public Builder endAt(String endAt) {
            this.endAt = OptionalNullable.of((Object)endAt);
            return this;
        }

        public Builder unsetEndAt() {
            this.endAt = null;
            return this;
        }

        public TimeRange build() {
            return new TimeRange(this.startAt, this.endAt);
        }
    }
}

