/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Booking;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class UpdateBookingResponse {
    private HttpContext httpContext;
    private final Booking booking;
    private final List<Error> errors;

    @JsonCreator
    public UpdateBookingResponse(@JsonProperty(value="booking") Booking booking, @JsonProperty(value="errors") List<Error> errors) {
        this.booking = booking;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="booking")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Booking getBooking() {
        return this.booking;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.booking, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateBookingResponse)) {
            return false;
        }
        UpdateBookingResponse other = (UpdateBookingResponse)obj;
        return Objects.equals(this.booking, other.booking) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "UpdateBookingResponse [booking=" + this.booking + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().booking(this.getBooking()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private Booking booking;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder booking(Booking booking) {
            this.booking = booking;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public UpdateBookingResponse build() {
            UpdateBookingResponse model = new UpdateBookingResponse(this.booking, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

