/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CatalogObject;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class UpdateCatalogImageResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final CatalogObject image;

    @JsonCreator
    public UpdateCatalogImageResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="image") CatalogObject image) {
        this.errors = errors;
        this.image = image;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="image")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogObject getImage() {
        return this.image;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.image);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateCatalogImageResponse)) {
            return false;
        }
        UpdateCatalogImageResponse other = (UpdateCatalogImageResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.image, other.image);
    }

    public String toString() {
        return "UpdateCatalogImageResponse [errors=" + this.errors + ", image=" + this.image + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).image(this.getImage());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private CatalogObject image;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder image(CatalogObject image) {
            this.image = image;
            return this;
        }

        public UpdateCatalogImageResponse build() {
            UpdateCatalogImageResponse model = new UpdateCatalogImageResponse(this.errors, this.image);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

