/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Address;
import com.squareup.square.models.CustomerTaxIds;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class UpdateCustomerRequest {
    private final OptionalNullable<String> givenName;
    private final OptionalNullable<String> familyName;
    private final OptionalNullable<String> companyName;
    private final OptionalNullable<String> nickname;
    private final OptionalNullable<String> emailAddress;
    private final Address address;
    private final OptionalNullable<String> phoneNumber;
    private final OptionalNullable<String> referenceId;
    private final OptionalNullable<String> note;
    private final OptionalNullable<String> birthday;
    private final Long version;
    private final CustomerTaxIds taxIds;

    @JsonCreator
    public UpdateCustomerRequest(@JsonProperty(value="given_name") String givenName, @JsonProperty(value="family_name") String familyName, @JsonProperty(value="company_name") String companyName, @JsonProperty(value="nickname") String nickname, @JsonProperty(value="email_address") String emailAddress, @JsonProperty(value="address") Address address, @JsonProperty(value="phone_number") String phoneNumber, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="note") String note, @JsonProperty(value="birthday") String birthday, @JsonProperty(value="version") Long version, @JsonProperty(value="tax_ids") CustomerTaxIds taxIds) {
        this.givenName = OptionalNullable.of((Object)givenName);
        this.familyName = OptionalNullable.of((Object)familyName);
        this.companyName = OptionalNullable.of((Object)companyName);
        this.nickname = OptionalNullable.of((Object)nickname);
        this.emailAddress = OptionalNullable.of((Object)emailAddress);
        this.address = address;
        this.phoneNumber = OptionalNullable.of((Object)phoneNumber);
        this.referenceId = OptionalNullable.of((Object)referenceId);
        this.note = OptionalNullable.of((Object)note);
        this.birthday = OptionalNullable.of((Object)birthday);
        this.version = version;
        this.taxIds = taxIds;
    }

    protected UpdateCustomerRequest(OptionalNullable<String> givenName, OptionalNullable<String> familyName, OptionalNullable<String> companyName, OptionalNullable<String> nickname, OptionalNullable<String> emailAddress, Address address, OptionalNullable<String> phoneNumber, OptionalNullable<String> referenceId, OptionalNullable<String> note, OptionalNullable<String> birthday, Long version, CustomerTaxIds taxIds) {
        this.givenName = givenName;
        this.familyName = familyName;
        this.companyName = companyName;
        this.nickname = nickname;
        this.emailAddress = emailAddress;
        this.address = address;
        this.phoneNumber = phoneNumber;
        this.referenceId = referenceId;
        this.note = note;
        this.birthday = birthday;
        this.version = version;
        this.taxIds = taxIds;
    }

    @JsonGetter(value="given_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetGivenName() {
        return this.givenName;
    }

    @JsonIgnore
    public String getGivenName() {
        return (String)OptionalNullable.getFrom(this.givenName);
    }

    @JsonGetter(value="family_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetFamilyName() {
        return this.familyName;
    }

    @JsonIgnore
    public String getFamilyName() {
        return (String)OptionalNullable.getFrom(this.familyName);
    }

    @JsonGetter(value="company_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCompanyName() {
        return this.companyName;
    }

    @JsonIgnore
    public String getCompanyName() {
        return (String)OptionalNullable.getFrom(this.companyName);
    }

    @JsonGetter(value="nickname")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetNickname() {
        return this.nickname;
    }

    @JsonIgnore
    public String getNickname() {
        return (String)OptionalNullable.getFrom(this.nickname);
    }

    @JsonGetter(value="email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEmailAddress() {
        return this.emailAddress;
    }

    @JsonIgnore
    public String getEmailAddress() {
        return (String)OptionalNullable.getFrom(this.emailAddress);
    }

    @JsonGetter(value="address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getAddress() {
        return this.address;
    }

    @JsonGetter(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonIgnore
    public String getPhoneNumber() {
        return (String)OptionalNullable.getFrom(this.phoneNumber);
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetReferenceId() {
        return this.referenceId;
    }

    @JsonIgnore
    public String getReferenceId() {
        return (String)OptionalNullable.getFrom(this.referenceId);
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetNote() {
        return this.note;
    }

    @JsonIgnore
    public String getNote() {
        return (String)OptionalNullable.getFrom(this.note);
    }

    @JsonGetter(value="birthday")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBirthday() {
        return this.birthday;
    }

    @JsonIgnore
    public String getBirthday() {
        return (String)OptionalNullable.getFrom(this.birthday);
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getVersion() {
        return this.version;
    }

    @JsonGetter(value="tax_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerTaxIds getTaxIds() {
        return this.taxIds;
    }

    public int hashCode() {
        return Objects.hash(this.givenName, this.familyName, this.companyName, this.nickname, this.emailAddress, this.address, this.phoneNumber, this.referenceId, this.note, this.birthday, this.version, this.taxIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateCustomerRequest)) {
            return false;
        }
        UpdateCustomerRequest other = (UpdateCustomerRequest)obj;
        return Objects.equals(this.givenName, other.givenName) && Objects.equals(this.familyName, other.familyName) && Objects.equals(this.companyName, other.companyName) && Objects.equals(this.nickname, other.nickname) && Objects.equals(this.emailAddress, other.emailAddress) && Objects.equals(this.address, other.address) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.note, other.note) && Objects.equals(this.birthday, other.birthday) && Objects.equals(this.version, other.version) && Objects.equals(this.taxIds, other.taxIds);
    }

    public String toString() {
        return "UpdateCustomerRequest [givenName=" + this.givenName + ", familyName=" + this.familyName + ", companyName=" + this.companyName + ", nickname=" + this.nickname + ", emailAddress=" + this.emailAddress + ", address=" + this.address + ", phoneNumber=" + this.phoneNumber + ", referenceId=" + this.referenceId + ", note=" + this.note + ", birthday=" + this.birthday + ", version=" + this.version + ", taxIds=" + this.taxIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().address(this.getAddress()).version(this.getVersion()).taxIds(this.getTaxIds());
        builder.givenName = this.internalGetGivenName();
        builder.familyName = this.internalGetFamilyName();
        builder.companyName = this.internalGetCompanyName();
        builder.nickname = this.internalGetNickname();
        builder.emailAddress = this.internalGetEmailAddress();
        builder.phoneNumber = this.internalGetPhoneNumber();
        builder.referenceId = this.internalGetReferenceId();
        builder.note = this.internalGetNote();
        builder.birthday = this.internalGetBirthday();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> givenName;
        private OptionalNullable<String> familyName;
        private OptionalNullable<String> companyName;
        private OptionalNullable<String> nickname;
        private OptionalNullable<String> emailAddress;
        private Address address;
        private OptionalNullable<String> phoneNumber;
        private OptionalNullable<String> referenceId;
        private OptionalNullable<String> note;
        private OptionalNullable<String> birthday;
        private Long version;
        private CustomerTaxIds taxIds;

        public Builder givenName(String givenName) {
            this.givenName = OptionalNullable.of((Object)givenName);
            return this;
        }

        public Builder unsetGivenName() {
            this.givenName = null;
            return this;
        }

        public Builder familyName(String familyName) {
            this.familyName = OptionalNullable.of((Object)familyName);
            return this;
        }

        public Builder unsetFamilyName() {
            this.familyName = null;
            return this;
        }

        public Builder companyName(String companyName) {
            this.companyName = OptionalNullable.of((Object)companyName);
            return this;
        }

        public Builder unsetCompanyName() {
            this.companyName = null;
            return this;
        }

        public Builder nickname(String nickname) {
            this.nickname = OptionalNullable.of((Object)nickname);
            return this;
        }

        public Builder unsetNickname() {
            this.nickname = null;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = OptionalNullable.of((Object)emailAddress);
            return this;
        }

        public Builder unsetEmailAddress() {
            this.emailAddress = null;
            return this;
        }

        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = OptionalNullable.of((Object)phoneNumber);
            return this;
        }

        public Builder unsetPhoneNumber() {
            this.phoneNumber = null;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = OptionalNullable.of((Object)referenceId);
            return this;
        }

        public Builder unsetReferenceId() {
            this.referenceId = null;
            return this;
        }

        public Builder note(String note) {
            this.note = OptionalNullable.of((Object)note);
            return this;
        }

        public Builder unsetNote() {
            this.note = null;
            return this;
        }

        public Builder birthday(String birthday) {
            this.birthday = OptionalNullable.of((Object)birthday);
            return this;
        }

        public Builder unsetBirthday() {
            this.birthday = null;
            return this;
        }

        public Builder version(Long version) {
            this.version = version;
            return this;
        }

        public Builder taxIds(CustomerTaxIds taxIds) {
            this.taxIds = taxIds;
            return this;
        }

        public UpdateCustomerRequest build() {
            return new UpdateCustomerRequest(this.givenName, this.familyName, this.companyName, this.nickname, this.emailAddress, this.address, this.phoneNumber, this.referenceId, this.note, this.birthday, this.version, this.taxIds);
        }
    }
}

