/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Customer;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class UpdateCustomerResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final Customer customer;

    @JsonCreator
    public UpdateCustomerResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="customer") Customer customer) {
        this.errors = errors;
        this.customer = customer;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="customer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Customer getCustomer() {
        return this.customer;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.customer);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateCustomerResponse)) {
            return false;
        }
        UpdateCustomerResponse other = (UpdateCustomerResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.customer, other.customer);
    }

    public String toString() {
        return "UpdateCustomerResponse [errors=" + this.errors + ", customer=" + this.customer + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).customer(this.getCustomer());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private Customer customer;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public UpdateCustomerResponse build() {
            UpdateCustomerResponse model = new UpdateCustomerResponse(this.errors, this.customer);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

