/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Invoice;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class UpdateInvoiceRequest {
    private final Invoice invoice;
    private final OptionalNullable<String> idempotencyKey;
    private final OptionalNullable<List<String>> fieldsToClear;

    @JsonCreator
    public UpdateInvoiceRequest(@JsonProperty(value="invoice") Invoice invoice, @JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="fields_to_clear") List<String> fieldsToClear) {
        this.invoice = invoice;
        this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
        this.fieldsToClear = OptionalNullable.of(fieldsToClear);
    }

    protected UpdateInvoiceRequest(Invoice invoice, OptionalNullable<String> idempotencyKey, OptionalNullable<List<String>> fieldsToClear) {
        this.invoice = invoice;
        this.idempotencyKey = idempotencyKey;
        this.fieldsToClear = fieldsToClear;
    }

    @JsonGetter(value="invoice")
    public Invoice getInvoice() {
        return this.invoice;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonIgnore
    public String getIdempotencyKey() {
        return (String)OptionalNullable.getFrom(this.idempotencyKey);
    }

    @JsonGetter(value="fields_to_clear")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetFieldsToClear() {
        return this.fieldsToClear;
    }

    @JsonIgnore
    public List<String> getFieldsToClear() {
        return (List)OptionalNullable.getFrom(this.fieldsToClear);
    }

    public int hashCode() {
        return Objects.hash(this.invoice, this.idempotencyKey, this.fieldsToClear);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateInvoiceRequest)) {
            return false;
        }
        UpdateInvoiceRequest other = (UpdateInvoiceRequest)obj;
        return Objects.equals(this.invoice, other.invoice) && Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.fieldsToClear, other.fieldsToClear);
    }

    public String toString() {
        return "UpdateInvoiceRequest [invoice=" + this.invoice + ", idempotencyKey=" + this.idempotencyKey + ", fieldsToClear=" + this.fieldsToClear + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.invoice);
        builder.idempotencyKey = this.internalGetIdempotencyKey();
        builder.fieldsToClear = this.internalGetFieldsToClear();
        return builder;
    }

    public static class Builder {
        private Invoice invoice;
        private OptionalNullable<String> idempotencyKey;
        private OptionalNullable<List<String>> fieldsToClear;

        public Builder(Invoice invoice) {
            this.invoice = invoice;
        }

        public Builder invoice(Invoice invoice) {
            this.invoice = invoice;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
            return this;
        }

        public Builder unsetIdempotencyKey() {
            this.idempotencyKey = null;
            return this;
        }

        public Builder fieldsToClear(List<String> fieldsToClear) {
            this.fieldsToClear = OptionalNullable.of(fieldsToClear);
            return this;
        }

        public Builder unsetFieldsToClear() {
            this.fieldsToClear = null;
            return this;
        }

        public UpdateInvoiceRequest build() {
            return new UpdateInvoiceRequest(this.invoice, this.idempotencyKey, this.fieldsToClear);
        }
    }
}

