/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class UpdateItemModifierListsRequest {
    private final List<String> itemIds;
    private final OptionalNullable<List<String>> modifierListsToEnable;
    private final OptionalNullable<List<String>> modifierListsToDisable;

    @JsonCreator
    public UpdateItemModifierListsRequest(@JsonProperty(value="item_ids") List<String> itemIds, @JsonProperty(value="modifier_lists_to_enable") List<String> modifierListsToEnable, @JsonProperty(value="modifier_lists_to_disable") List<String> modifierListsToDisable) {
        this.itemIds = itemIds;
        this.modifierListsToEnable = OptionalNullable.of(modifierListsToEnable);
        this.modifierListsToDisable = OptionalNullable.of(modifierListsToDisable);
    }

    protected UpdateItemModifierListsRequest(List<String> itemIds, OptionalNullable<List<String>> modifierListsToEnable, OptionalNullable<List<String>> modifierListsToDisable) {
        this.itemIds = itemIds;
        this.modifierListsToEnable = modifierListsToEnable;
        this.modifierListsToDisable = modifierListsToDisable;
    }

    @JsonGetter(value="item_ids")
    public List<String> getItemIds() {
        return this.itemIds;
    }

    @JsonGetter(value="modifier_lists_to_enable")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetModifierListsToEnable() {
        return this.modifierListsToEnable;
    }

    @JsonIgnore
    public List<String> getModifierListsToEnable() {
        return (List)OptionalNullable.getFrom(this.modifierListsToEnable);
    }

    @JsonGetter(value="modifier_lists_to_disable")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetModifierListsToDisable() {
        return this.modifierListsToDisable;
    }

    @JsonIgnore
    public List<String> getModifierListsToDisable() {
        return (List)OptionalNullable.getFrom(this.modifierListsToDisable);
    }

    public int hashCode() {
        return Objects.hash(this.itemIds, this.modifierListsToEnable, this.modifierListsToDisable);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateItemModifierListsRequest)) {
            return false;
        }
        UpdateItemModifierListsRequest other = (UpdateItemModifierListsRequest)obj;
        return Objects.equals(this.itemIds, other.itemIds) && Objects.equals(this.modifierListsToEnable, other.modifierListsToEnable) && Objects.equals(this.modifierListsToDisable, other.modifierListsToDisable);
    }

    public String toString() {
        return "UpdateItemModifierListsRequest [itemIds=" + this.itemIds + ", modifierListsToEnable=" + this.modifierListsToEnable + ", modifierListsToDisable=" + this.modifierListsToDisable + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.itemIds);
        builder.modifierListsToEnable = this.internalGetModifierListsToEnable();
        builder.modifierListsToDisable = this.internalGetModifierListsToDisable();
        return builder;
    }

    public static class Builder {
        private List<String> itemIds;
        private OptionalNullable<List<String>> modifierListsToEnable;
        private OptionalNullable<List<String>> modifierListsToDisable;

        public Builder(List<String> itemIds) {
            this.itemIds = itemIds;
        }

        public Builder itemIds(List<String> itemIds) {
            this.itemIds = itemIds;
            return this;
        }

        public Builder modifierListsToEnable(List<String> modifierListsToEnable) {
            this.modifierListsToEnable = OptionalNullable.of(modifierListsToEnable);
            return this;
        }

        public Builder unsetModifierListsToEnable() {
            this.modifierListsToEnable = null;
            return this;
        }

        public Builder modifierListsToDisable(List<String> modifierListsToDisable) {
            this.modifierListsToDisable = OptionalNullable.of(modifierListsToDisable);
            return this;
        }

        public Builder unsetModifierListsToDisable() {
            this.modifierListsToDisable = null;
            return this;
        }

        public UpdateItemModifierListsRequest build() {
            return new UpdateItemModifierListsRequest(this.itemIds, this.modifierListsToEnable, this.modifierListsToDisable);
        }
    }
}

