/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CheckoutLocationSettings;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class UpdateLocationSettingsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final CheckoutLocationSettings locationSettings;

    @JsonCreator
    public UpdateLocationSettingsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="location_settings") CheckoutLocationSettings locationSettings) {
        this.errors = errors;
        this.locationSettings = locationSettings;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="location_settings")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CheckoutLocationSettings getLocationSettings() {
        return this.locationSettings;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.locationSettings);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateLocationSettingsResponse)) {
            return false;
        }
        UpdateLocationSettingsResponse other = (UpdateLocationSettingsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.locationSettings, other.locationSettings);
    }

    public String toString() {
        return "UpdateLocationSettingsResponse [errors=" + this.errors + ", locationSettings=" + this.locationSettings + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).locationSettings(this.getLocationSettings());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private CheckoutLocationSettings locationSettings;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder locationSettings(CheckoutLocationSettings locationSettings) {
            this.locationSettings = locationSettings;
            return this;
        }

        public UpdateLocationSettingsResponse build() {
            UpdateLocationSettingsResponse model = new UpdateLocationSettingsResponse(this.errors, this.locationSettings);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

