/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CheckoutMerchantSettings;
import java.util.Objects;

public class UpdateMerchantSettingsRequest {
    private final CheckoutMerchantSettings merchantSettings;

    @JsonCreator
    public UpdateMerchantSettingsRequest(@JsonProperty(value="merchant_settings") CheckoutMerchantSettings merchantSettings) {
        this.merchantSettings = merchantSettings;
    }

    @JsonGetter(value="merchant_settings")
    public CheckoutMerchantSettings getMerchantSettings() {
        return this.merchantSettings;
    }

    public int hashCode() {
        return Objects.hash(this.merchantSettings);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateMerchantSettingsRequest)) {
            return false;
        }
        UpdateMerchantSettingsRequest other = (UpdateMerchantSettingsRequest)obj;
        return Objects.equals(this.merchantSettings, other.merchantSettings);
    }

    public String toString() {
        return "UpdateMerchantSettingsRequest [merchantSettings=" + this.merchantSettings + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.merchantSettings);
        return builder;
    }

    public static class Builder {
        private CheckoutMerchantSettings merchantSettings;

        public Builder(CheckoutMerchantSettings merchantSettings) {
            this.merchantSettings = merchantSettings;
        }

        public Builder merchantSettings(CheckoutMerchantSettings merchantSettings) {
            this.merchantSettings = merchantSettings;
            return this;
        }

        public UpdateMerchantSettingsRequest build() {
            return new UpdateMerchantSettingsRequest(this.merchantSettings);
        }
    }
}

