/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Shift;
import java.util.List;
import java.util.Objects;

public class UpdateShiftResponse {
    private HttpContext httpContext;
    private final Shift shift;
    private final List<Error> errors;

    @JsonCreator
    public UpdateShiftResponse(@JsonProperty(value="shift") Shift shift, @JsonProperty(value="errors") List<Error> errors) {
        this.shift = shift;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="shift")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Shift getShift() {
        return this.shift;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.shift, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateShiftResponse)) {
            return false;
        }
        UpdateShiftResponse other = (UpdateShiftResponse)obj;
        return Objects.equals(this.shift, other.shift) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "UpdateShiftResponse [shift=" + this.shift + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().shift(this.getShift()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private Shift shift;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder shift(Shift shift) {
            this.shift = shift;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public UpdateShiftResponse build() {
            UpdateShiftResponse model = new UpdateShiftResponse(this.shift, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

