/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Vendor;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class UpdateVendorRequest {
    private final OptionalNullable<String> idempotencyKey;
    private final Vendor vendor;

    @JsonCreator
    public UpdateVendorRequest(@JsonProperty(value="vendor") Vendor vendor, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
        this.vendor = vendor;
    }

    protected UpdateVendorRequest(Vendor vendor, OptionalNullable<String> idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        this.vendor = vendor;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonIgnore
    public String getIdempotencyKey() {
        return (String)OptionalNullable.getFrom(this.idempotencyKey);
    }

    @JsonGetter(value="vendor")
    public Vendor getVendor() {
        return this.vendor;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.vendor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateVendorRequest)) {
            return false;
        }
        UpdateVendorRequest other = (UpdateVendorRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.vendor, other.vendor);
    }

    public String toString() {
        return "UpdateVendorRequest [vendor=" + this.vendor + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.vendor);
        builder.idempotencyKey = this.internalGetIdempotencyKey();
        return builder;
    }

    public static class Builder {
        private Vendor vendor;
        private OptionalNullable<String> idempotencyKey;

        public Builder(Vendor vendor) {
            this.vendor = vendor;
        }

        public Builder vendor(Vendor vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
            return this;
        }

        public Builder unsetIdempotencyKey() {
            this.idempotencyKey = null;
            return this;
        }

        public UpdateVendorRequest build() {
            return new UpdateVendorRequest(this.vendor, this.idempotencyKey);
        }
    }
}

