/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class UpdateWebhookSubscriptionSignatureKeyResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final String signatureKey;

    @JsonCreator
    public UpdateWebhookSubscriptionSignatureKeyResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="signature_key") String signatureKey) {
        this.errors = errors;
        this.signatureKey = signatureKey;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="signature_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSignatureKey() {
        return this.signatureKey;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.signatureKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateWebhookSubscriptionSignatureKeyResponse)) {
            return false;
        }
        UpdateWebhookSubscriptionSignatureKeyResponse other = (UpdateWebhookSubscriptionSignatureKeyResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.signatureKey, other.signatureKey);
    }

    public String toString() {
        return "UpdateWebhookSubscriptionSignatureKeyResponse [errors=" + this.errors + ", signatureKey=" + this.signatureKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).signatureKey(this.getSignatureKey());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private String signatureKey;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder signatureKey(String signatureKey) {
            this.signatureKey = signatureKey;
            return this;
        }

        public UpdateWebhookSubscriptionSignatureKeyResponse build() {
            UpdateWebhookSubscriptionSignatureKeyResponse model = new UpdateWebhookSubscriptionSignatureKeyResponse(this.errors, this.signatureKey);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

